/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.ws.handler.Handler;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireTarget;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.ArtifactCache;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.InterceptorMonitor;
import org.fabric3.binding.ws.metro.runtime.core.MetroJavaTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.MetroProxySupplier;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroTargetWireAttacher;
import org.fabric3.spi.container.binding.BindingHandlerRegistry;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.binding.ws.metro.provision.MetroJavaWireTarget")
public class MetroJavaTargetWireAttacher
extends AbstractMetroTargetWireAttacher<MetroJavaWireTarget> {
    private ArtifactCache artifactCache;
    private ExecutorService executorService;
    private XMLInputFactory xmlInputFactory;
    private InterceptorMonitor monitor;

    public MetroJavaTargetWireAttacher(@Reference EndpointService endpointService, @Reference ArtifactCache artifactCache, @Reference(name="executorService") ExecutorService executorService, @Reference BindingHandlerRegistry handlerRegistry, @Monitor InterceptorMonitor monitor) {
        super(handlerRegistry);
        this.artifactCache = artifactCache;
        this.executorService = executorService;
        this.xmlInputFactory = XMLInputFactory.newFactory();
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(PhysicalWireSource source, MetroJavaWireTarget target, Wire wire) throws Fabric3Exception {
        try {
            ReferenceEndpointDefinition endpointDefinition = target.getEndpointDefinition();
            Class<?> seiClass = target.getInterface();
            ClassLoader classLoader = seiClass.getClassLoader();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                URL wsdlLocation = target.getWsdlLocation();
                URL generatedWsdl = null;
                URI servicePath = target.getEndpointDefinition().getUrl().toURI();
                String wsdl = target.getWsdl();
                if (wsdl != null) {
                    generatedWsdl = wsdlLocation = this.artifactCache.cache(servicePath, new ByteArrayInputStream(wsdl.getBytes()));
                    this.cacheSchemas(servicePath, target);
                }
                ConnectionConfiguration connectionConfiguration = target.getConnectionConfiguration();
                List<Handler> handlers = this.createHandlers(target);
                MetroProxySupplier proxyFactory = new MetroProxySupplier(endpointDefinition, wsdlLocation, generatedWsdl, seiClass, connectionConfiguration, handlers, this.executorService, this.xmlInputFactory);
                this.attachInterceptors(seiClass, target, wire, proxyFactory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (URISyntaxException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private List<URL> cacheSchemas(URI servicePath, MetroJavaWireTarget target) throws Fabric3Exception {
        ArrayList<URL> schemas = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : target.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            ByteArrayInputStream bas = new ByteArrayInputStream(entry.getValue().getBytes());
            URL url = this.artifactCache.cache(uri, bas);
            schemas.add(url);
        }
        return schemas;
    }

    private void attachInterceptors(Class<?> seiClass, MetroJavaWireTarget target, Wire wire, Supplier<?> factory) {
        Method[] methods = seiClass.getMethods();
        int retries = target.getRetries();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method = null;
            for (Method m : methods) {
                if (!chain.getPhysicalOperation().getName().equals(m.getName())) continue;
                method = m;
                break;
            }
            boolean oneWay = chain.getPhysicalOperation().isOneWay();
            MetroJavaTargetInterceptor targetInterceptor = new MetroJavaTargetInterceptor(factory, method, oneWay, retries, this.monitor);
            chain.addInterceptor((Interceptor)targetInterceptor);
        }
    }
}

