/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireSource;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.ArtifactCache;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.JaxbInvoker;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroSourceWireAttacher;
import org.fabric3.spi.container.binding.BindingHandlerRegistry;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.binding.ws.metro.provision.MetroJavaWireSource")
public class MetroJavaSourceWireAttacher
extends AbstractMetroSourceWireAttacher<MetroJavaWireSource> {
    private ArtifactCache artifactCache;

    public MetroJavaSourceWireAttacher(@Reference ArtifactCache artifactCache, @Reference EndpointService endpointService, @Reference BindingHandlerRegistry handlerRegistry) {
        super(endpointService, handlerRegistry);
        this.artifactCache = artifactCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(MetroJavaWireSource source, PhysicalWireTarget target, Wire wire) throws Fabric3Exception {
        ServiceEndpointDefinition endpointDefinition = source.getEndpointDefinition();
        QName serviceName = endpointDefinition.getServiceName();
        QName portName = endpointDefinition.getPortName();
        URI servicePath = endpointDefinition.getServicePath();
        List invocationChains = wire.getInvocationChains();
        URL wsdlLocation = source.getWsdlLocation();
        Class<?> seiClass = source.getInterface();
        ClassLoader classLoader = seiClass.getClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            String path;
            Thread.currentThread().setContextClassLoader(classLoader);
            URL generatedWsdl = null;
            List<URL> generatedSchemas = null;
            String wsdl = source.getWsdl();
            if (wsdl != null) {
                generatedWsdl = wsdlLocation = this.artifactCache.cache(servicePath, new ByteArrayInputStream(wsdl.getBytes()));
                generatedSchemas = this.cacheSchemas(servicePath, source);
            }
            if (!(path = servicePath.toString()).startsWith("/")) {
                path = "/" + path;
            }
            List<Handler> handlers = this.createHandlers(source);
            URI serviceUri = source.getServiceUri();
            JaxbInvoker invoker = new JaxbInvoker(invocationChains);
            EndpointConfiguration configuration = new EndpointConfiguration(serviceUri, seiClass, serviceName, portName, path, wsdlLocation, invoker, generatedWsdl, generatedSchemas, handlers);
            this.endpointService.registerService(configuration);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void detach(MetroJavaWireSource source, PhysicalWireTarget target) throws Fabric3Exception {
        ServiceEndpointDefinition endpointDefinition = source.getEndpointDefinition();
        URI servicePath = endpointDefinition.getServicePath();
        String path = servicePath.toString();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.artifactCache.remove(servicePath);
        String wsdl = source.getWsdl();
        if (wsdl != null) {
            this.removeCachedSchemas(servicePath, source);
        }
        this.endpointService.unregisterService(path);
    }

    private List<URL> cacheSchemas(URI servicePath, MetroJavaWireSource source) throws Fabric3Exception {
        ArrayList<URL> schemas = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : source.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            ByteArrayInputStream bas = new ByteArrayInputStream(entry.getValue().getBytes());
            URL url = this.artifactCache.cache(uri, bas);
            schemas.add(url);
        }
        return schemas;
    }

    private void removeCachedSchemas(URI servicePath, MetroJavaWireSource source) throws Fabric3Exception {
        for (Map.Entry<String, String> entry : source.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            this.artifactCache.remove(uri);
        }
    }
}

