/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.MetroWireSource;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.SOAPMessageHandlerAdapter;
import org.fabric3.spi.container.binding.BindingHandler;
import org.fabric3.spi.container.binding.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;

public abstract class AbstractMetroSourceWireAttacher<T extends MetroWireSource>
implements SourceWireAttacher<T> {
    protected EndpointService endpointService;
    private BindingHandlerRegistry handlerRegistry;

    public AbstractMetroSourceWireAttacher(EndpointService endpointService, BindingHandlerRegistry handlerRegistry) {
        this.endpointService = endpointService;
        this.handlerRegistry = handlerRegistry;
    }

    protected List<Handler> createHandlers(MetroWireSource source) {
        if (source.getHandlers().isEmpty() && !source.isBidirectional()) {
            return null;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (PhysicalBindingHandler physicalHandler : source.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(SOAPMessage.class, physicalHandler);
            SOAPMessageHandlerAdapter soapHandlerAdaptor = new SOAPMessageHandlerAdapter((BindingHandler<SOAPMessage>)handler);
            handlers.add((Handler)soapHandlerAdaptor);
        }
        return handlers;
    }
}

