/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroBindingProviderFactory;
import org.fabric3.binding.ws.metro.runtime.core.WsitClientConfigurationContainer;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetroProxySupplier
extends AbstractMetroBindingProviderFactory<Object> {
    private static final QName DEFINITIONS = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    private static final EntityResolver RESOLVER = new NullResolver();
    private URL wsdlLocation;
    private QName serviceName;
    private boolean serviceNameDefault;
    private QName portName;
    private QName portTypeName;
    private Class<?> seiClass;
    private URL wsitConfiguration;
    private ExecutorService executorService;
    private XMLInputFactory xmlInputFactory;
    private Object proxy;
    private URL endpointUrl;

    public MetroProxySupplier(ReferenceEndpointDefinition endpointDefinition, URL wsdlLocation, URL wsitConfiguration, Class<?> seiClass, ConnectionConfiguration connectionConfiguration, List<Handler> handlers, ExecutorService executorService, XMLInputFactory xmlInputFactory) {
        super(connectionConfiguration, handlers);
        this.serviceName = endpointDefinition.getServiceName();
        this.serviceNameDefault = endpointDefinition.isDefaultServiceName();
        this.portTypeName = endpointDefinition.getPortTypeName();
        this.portName = endpointDefinition.getPortName();
        this.endpointUrl = endpointDefinition.getUrl();
        this.wsdlLocation = wsdlLocation;
        this.seiClass = seiClass;
        this.wsitConfiguration = wsitConfiguration;
        this.executorService = executorService;
        this.xmlInputFactory = xmlInputFactory;
    }

    @Override
    public Object get() throws Fabric3Exception {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private Object createProxy() throws Fabric3Exception {
        ClassLoader seiClassLoader;
        if (this.wsdlLocation == null) {
            this.wsdlLocation = this.calculateDefaultWsdlLocation();
        }
        if ((seiClassLoader = this.seiClass.getClassLoader()) instanceof MultiParentClassLoader) {
            MultiParentClassLoader multiParentClassLoader = (MultiParentClassLoader)seiClassLoader;
            ClassLoader extensionCl = this.getClass().getClassLoader();
            if (!multiParentClassLoader.getParents().contains(extensionCl)) {
                multiParentClassLoader.addParent(extensionCl);
            }
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            BindingProvider port;
            Service service;
            Thread.currentThread().setContextClassLoader(seiClassLoader);
            WSService.InitParams params = new WSService.InitParams();
            WsitClientConfigurationContainer container = this.wsitConfiguration != null ? new WsitClientConfigurationContainer(this.wsitConfiguration) : new WsitClientConfigurationContainer();
            params.setContainer((Container)container);
            try {
                service = WSService.create((URL)this.wsdlLocation, (QName)this.serviceName, (WSService.InitParams)params);
            }
            catch (WebServiceException e) {
                service = this.getWsdlServiceName(e, params);
            }
            service.setExecutor((Executor)this.executorService);
            if (this.portName == null) {
                this.portName = (QName)service.getPorts().next();
            }
            try {
                port = (BindingProvider)service.getPort(this.portName, this.seiClass);
            }
            catch (WebServiceException e) {
                if (e.getMessage().contains("not a valid port")) {
                    this.portName = (QName)service.getPorts().next();
                    port = (BindingProvider)service.getPort(this.portName, this.seiClass);
                }
                throw e;
            }
            this.configureConnection(port);
            this.configureHandlers(port);
            BindingProvider bindingProvider = port;
            return bindingProvider;
        }
        catch (InaccessibleWSDLException | MalformedURLException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Service getWsdlServiceName(WebServiceException e, WSService.InitParams params) throws Fabric3Exception, WebServiceException {
        Service service;
        if (!this.serviceNameDefault || !this.isInvalidServiceName(e)) {
            throw e;
        }
        InputStream stream = null;
        try {
            HashSet<QName> found = new HashSet<QName>();
            stream = this.wsdlLocation.openStream();
            StreamSource source = new StreamSource(stream);
            WSDLModelImpl model = RuntimeWSDLParser.parse((URL)this.wsdlLocation, (Source)source, (EntityResolver)RESOLVER, (boolean)false, null, (WSDLParserExtension[])new WSDLParserExtension[0]);
            for (WSDLService wsdlService : model.getServices().values()) {
                for (WSDLPort wsdlPort : wsdlService.getPorts()) {
                    if (!wsdlPort.getBinding().getPortType().getName().equals(this.portTypeName)) continue;
                    found.add(wsdlService.getName());
                }
            }
            if (found.size() > 1) {
                throw new Fabric3Exception("Cannot determine the default service name as multiple ports using portType " + this.portTypeName + " were found in the WSDL document: " + this.wsdlLocation);
            }
            if (found.isEmpty()) {
                throw new Fabric3Exception("No default service for portType" + this.portTypeName + " found in WSDL: " + this.wsdlLocation);
            }
            QName defaultServiceName = (QName)found.iterator().next();
            service = WSService.create((URL)this.wsdlLocation, (QName)defaultServiceName, (WSService.InitParams)params);
        }
        catch (IOException | XMLStreamException | SAXException e1) {
            throw new Fabric3Exception((Throwable)e1);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return service;
    }

    private URL calculateDefaultWsdlLocation() throws Fabric3Exception {
        try {
            URL wsdlUrl = new URL(this.endpointUrl.toString() + "?wsdl");
            if (this.isWsdl(wsdlUrl)) {
                return wsdlUrl;
            }
            String str = this.endpointUrl.toString();
            int pos = str.lastIndexOf("/");
            if (pos > 0 && this.isWsdl(wsdlUrl = new URL(str.substring(0, pos) + "?wsdl"))) {
                return wsdlUrl;
            }
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception((Throwable)e);
        }
        throw new Fabric3Exception("The web service endpoint " + this.endpointUrl + " does not expose a valid WSDL at a known metadata location, e.g. <service url>?wsdl. Check to make sure the endpoint address is correct. If it is, please specify a valid location using the @WebService annotation on the reference interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWsdl(URL wsdlUrl) {
        InputStream stream = null;
        XMLStreamReader reader = null;
        try {
            stream = wsdlUrl.openStream();
            reader = this.xmlInputFactory.createXMLStreamReader(stream);
            reader.nextTag();
            if (DEFINITIONS.equals(reader.getName())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException | NullPointerException | XMLStreamException exception) {
        }
        finally {
            this.close(stream);
            this.close(reader);
        }
        return false;
    }

    private boolean isInvalidServiceName(WebServiceException e) throws Fabric3Exception {
        String message = ClientMessages.INVALID_SERVICE_NAME((Object)this.serviceName, null);
        int index = message.indexOf("null");
        if (index < 1) {
            throw new Fabric3Exception("Unable to parse error message after proxy creation error was thrown: " + message, (Throwable)e);
        }
        message = message.substring(0, index);
        return e.getMessage().contains(message);
    }

    private void close(XMLStreamReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NullResolver
    implements EntityResolver {
        private NullResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }
    }
}

