/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.function.Supplier;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.InterceptorMonitor;
import org.fabric3.spi.container.invocation.Message;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class MetroJavaTargetInterceptor
extends AbstractMetroTargetInterceptor {
    private Supplier<?> supplier;
    private Method method;
    private boolean oneWay;
    private int retries = 0;
    private InterceptorMonitor monitor;

    public MetroJavaTargetInterceptor(Supplier<?> supplier, Method method, boolean oneWay, int retries, InterceptorMonitor monitor) {
        this.supplier = supplier;
        this.method = method;
        this.oneWay = oneWay;
        this.retries = retries;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Object proxy = this.createProxy();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Message message = this.invokeRetry(msg, proxy);
            return message;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Message invokeRetry(Message msg, Object proxy) {
        int retry = 0;
        Object[] payload = (Object[])msg.getBody();
        while (true) {
            try {
                if (this.oneWay) {
                    this.method.invoke(proxy, payload);
                    return NULL_RESPONSE;
                }
                Object ret = this.method.invoke(proxy, payload);
                msg.setBody(ret);
                return msg;
            }
            catch (WebServiceException e) {
                if (e.getCause() instanceof SocketTimeoutException) {
                    if (retry > this.retries) {
                        throw new ServiceUnavailableException((Throwable)e);
                    }
                    this.monitor.serviceUnavailableRetry(e);
                    ++retry;
                    continue;
                }
                throw new ServiceRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof WebServiceException && !(e.getTargetException() instanceof SOAPFaultException)) {
                    WebServiceException wse = (WebServiceException)e.getTargetException();
                    if (wse.getCause() instanceof SocketTimeoutException) {
                        if (retry >= this.retries) {
                            throw new ServiceUnavailableException((Throwable)e);
                        }
                        this.monitor.serviceUnavailableRetry(wse.getCause());
                        ++retry;
                        continue;
                    }
                    throw new ServiceRuntimeException((Throwable)e);
                }
                msg.setBodyWithFault((Object)e.getTargetException());
                return msg;
            }
            break;
        }
    }

    private Object createProxy() {
        try {
            return this.supplier.get();
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

