/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroBindingProviderFactory;
import org.fabric3.binding.ws.metro.runtime.core.WsitClientConfigurationContainer;

public class MetroDispatchSupplier
extends AbstractMetroBindingProviderFactory<Dispatch<Source>> {
    private QName serviceName;
    private QName portName;
    private WebServiceFeature[] features;
    private File wsitConfiguration;
    private ExecutorService executorService;
    private Dispatch<Source> dispatch;
    private URL wsdlLocation;

    public MetroDispatchSupplier(ReferenceEndpointDefinition endpointDefinition, URL wsdlLocation, File wsitConfiguration, ConnectionConfiguration connectionConfiguration, List<Handler> handlers, WebServiceFeature[] features, ExecutorService executorService) {
        super(connectionConfiguration, handlers);
        this.wsdlLocation = wsdlLocation;
        this.serviceName = endpointDefinition.getServiceName();
        this.portName = endpointDefinition.getPortName();
        this.features = features;
        this.wsitConfiguration = wsitConfiguration;
        this.executorService = executorService;
    }

    @Override
    public Dispatch<Source> get() throws Fabric3Exception {
        if (this.dispatch == null) {
            this.dispatch = this.createProxy();
        }
        return this.dispatch;
    }

    private Dispatch<Source> createProxy() throws Fabric3Exception {
        try {
            WSService.InitParams params = new WSService.InitParams();
            WsitClientConfigurationContainer container = this.wsitConfiguration != null ? new WsitClientConfigurationContainer(this.wsitConfiguration.toURI().toURL()) : new WsitClientConfigurationContainer();
            params.setContainer((Container)container);
            Service service = WSService.create((URL)this.wsdlLocation, (QName)this.serviceName, (WSService.InitParams)params);
            service.setExecutor((Executor)this.executorService);
            Dispatch dispatch = service.createDispatch(this.portName, Source.class, Service.Mode.PAYLOAD, this.features);
            this.configureConnection((BindingProvider)dispatch);
            this.configureHandlers((BindingProvider)dispatch);
            this.setSOAPAction((Dispatch<Source>)dispatch);
            return dispatch;
        }
        catch (InaccessibleWSDLException | MalformedURLException e) {
            throw new Fabric3Exception(e);
        }
    }

    private void setSOAPAction(Dispatch<Source> dispatch) {
        Map context = dispatch.getRequestContext();
        context.put("javax.xml.ws.soap.http.soapaction.use", true);
        context.put("javax.xml.ws.soap.http.soapaction.uri", "");
    }
}

