/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.ws.metro.MetroBindingMonitor;
import org.fabric3.binding.ws.metro.runtime.core.EndpointConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.MetroServlet;
import org.fabric3.spi.host.ServletHost;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

public class EndpointServiceImpl
implements EndpointService {
    private ExecutorService executorService;
    private ServletHost servletHost;
    private MetroBindingMonitor monitor;
    private Map<URI, URL> endpointUrls;
    private MetroServlet metroServlet;

    public EndpointServiceImpl(@Reference(name="executorService") ExecutorService executorService, @Reference ServletHost servletHost, @Monitor MetroBindingMonitor monitor) {
        this.executorService = executorService;
        this.monitor = monitor;
        this.servletHost = servletHost;
        this.endpointUrls = new HashMap<URI, URL>();
    }

    @Init
    public void init() {
        this.metroServlet = new MetroServlet(this.executorService);
    }

    @Override
    public void registerService(EndpointConfiguration configuration) throws Fabric3Exception {
        String servicePath = configuration.getServicePath();
        if (this.servletHost.isMappingRegistered(servicePath)) {
            this.unregisterService(servicePath);
        }
        this.servletHost.registerMapping(servicePath, (Servlet)this.metroServlet);
        this.servletHost.registerMapping(servicePath + "/mex", (Servlet)this.metroServlet);
        this.metroServlet.registerService(configuration);
        try {
            URL endpointUrl = new URL(this.servletHost.getBaseHttpUrl().toString() + servicePath);
            this.endpointUrls.put(configuration.getServiceUri(), endpointUrl);
            this.monitor.endpointProvisioned(servicePath);
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception("Error registering service: " + servicePath, (Throwable)e);
        }
    }

    @Override
    public void unregisterService(String servicePath) throws Fabric3Exception {
        try {
            this.servletHost.unregisterMapping(servicePath);
            this.servletHost.unregisterMapping(servicePath + "/mex");
            this.metroServlet.unregisterService(servicePath);
            URL endpointUrl = new URL(this.servletHost.getBaseHttpUrl().toString() + servicePath);
            for (Map.Entry<URI, URL> entry : this.endpointUrls.entrySet()) {
                if (!entry.getValue().equals(endpointUrl)) continue;
                this.endpointUrls.remove(entry.getKey());
                break;
            }
            this.monitor.endpointRemoved(servicePath);
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception("Error registering service: " + servicePath, (Throwable)e);
        }
    }

    @Override
    public URL getEndpointUrl(URI serviceUri) {
        return this.endpointUrls.get(serviceUri);
    }
}

