/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;

public abstract class AbstractMetroBindingProviderFactory<T>
implements Supplier<T> {
    private ConnectionConfiguration connectionConfig;
    private List<Handler> handlers;

    public AbstractMetroBindingProviderFactory(ConnectionConfiguration connConfig, List<Handler> handlers) {
        this.connectionConfig = connConfig;
        this.handlers = handlers;
    }

    protected void configureConnection(BindingProvider provider) {
        if (this.connectionConfig == null) {
            return;
        }
        Map context = provider.getRequestContext();
        if (this.connectionConfig.getConnectTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.connect.timeout", this.connectionConfig.getConnectTimeout());
        }
        if (this.connectionConfig.getRequestTimeout() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.request.timeout", this.connectionConfig.getRequestTimeout());
        }
        if (this.connectionConfig.getClientStreamingChunkSize() != ConnectionConfiguration.DEFAULT) {
            context.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", this.connectionConfig.getClientStreamingChunkSize());
        }
    }

    protected void configureHandlers(BindingProvider provider) {
        if (this.handlers == null) {
            return;
        }
        String endpointPath = (String)provider.getRequestContext().get("javax.xml.ws.service.endpoint.address");
        if (endpointPath == null) {
            return;
        }
        provider.getBinding().setHandlerChain(this.handlers);
    }
}

