/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.api.binding.ws.model.WsBinding;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.oasisopen.sca.annotation.Reference;

public class TargetUrlResolverImpl
implements TargetUrlResolver {
    private ServletHost servletHost;
    private HostInfo hostInfo;

    public TargetUrlResolverImpl(@Reference ServletHost servletHost, @Reference HostInfo hostInfo) {
        this.servletHost = servletHost;
        this.hostInfo = hostInfo;
    }

    @Override
    public URL resolveUrl(LogicalBinding<WsBinding> binding) throws Fabric3Exception {
        try {
            URL targetUrl;
            String path = ((WsBinding)binding.getDefinition()).getTargetUri().toString();
            if (path == null) {
                path = ((LogicalBindable)binding.getParent()).getUri().getFragment();
            }
            boolean https = false;
            if (RuntimeMode.VM == this.hostInfo.getRuntimeMode()) {
                targetUrl = https ? new URL("https://localhost:" + this.servletHost.getHttpsPort() + "/" + path) : new URL("http://localhost:" + this.servletHost.getHttpPort() + "/" + path);
            } else {
                throw new Fabric3Exception("Resolve URL not supported in distributed configuration");
            }
            return targetUrl;
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }
}

