/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.ws.model.WsBinding;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.ws.metro.generator.GenerationHelper;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.generator.java.EndpointSynthesizer;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerator;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireSource;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireTarget;
import org.fabric3.binding.ws.metro.provision.MetroWireTarget;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.util.ClassLoaderUpdater;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.spi.model.type.java.JavaServiceContract")
public class JavaGeneratorDelegate
implements MetroGeneratorDelegate<JavaServiceContract> {
    private EndpointSynthesizer synthesizer;
    private InterfaceGenerator interfaceGenerator;
    private ClassLoaderUpdater classLoaderUpdater;
    private TargetUrlResolver targetUrlResolver;
    private HostInfo info;

    public JavaGeneratorDelegate(@Reference EndpointSynthesizer synthesizer, @Reference InterfaceGenerator interfaceGenerator, @Reference ClassLoaderUpdater classLoaderUpdater, @Reference TargetUrlResolver targetUrlResolver, @Reference HostInfo info) throws ParserConfigurationException {
        this.synthesizer = synthesizer;
        this.interfaceGenerator = interfaceGenerator;
        this.classLoaderUpdater = classLoaderUpdater;
        this.targetUrlResolver = targetUrlResolver;
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetroJavaWireSource generateSource(LogicalBinding<WsBinding> binding, JavaServiceContract contract) {
        Class<?> serviceClass = contract.getInterfaceClass();
        WsBinding bindingDefinition = (WsBinding)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(bindingDefinition, serviceClass);
        ServiceEndpointDefinition endpointDefinition = this.createServiceEndpointDefinition(binding, contract, serviceClass);
        Class<?> interfaze = contract.getInterfaceClass();
        List<PhysicalBindingHandler> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), bindingDefinition);
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                interfaze = serviceClass = generatedInterface.getGeneratedClass();
            }
            if (endpointDefinition.getWsdl() != null) {
                wsdl = endpointDefinition.getWsdl();
            }
            URI serviceUri = null;
            if (binding.isCallback()) {
                LogicalComponent component = (LogicalComponent)((LogicalBindable)binding.getParent()).getParent();
                for (LogicalService service : component.getServices()) {
                    if (!service.getServiceContract().getQualifiedInterfaceName().equals(contract.getQualifiedInterfaceName())) continue;
                    try {
                        serviceUri = new URI(component.getUri() + "#" + service.getDefinition().getName());
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new Fabric3Exception((Throwable)e);
                    }
                }
            } else {
                serviceUri = ((LogicalBindable)binding.getParent()).getUri();
            }
            boolean bidirectional = contract.getCallbackContract() != null && !binding.isCallback();
            Object object = new MetroJavaWireSource(serviceUri, endpointDefinition, interfaze, wsdl, schemas, wsdlLocation, bidirectional, handlers);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public MetroWireTarget generateTarget(LogicalBinding<WsBinding> binding, JavaServiceContract contract) {
        URL targetUrl = null;
        WsBinding bindingDefinition = (WsBinding)binding.getDefinition();
        URI targetUri = bindingDefinition.getTargetUri();
        if (binding.isCallback() && targetUri != null) {
            throw new Fabric3Exception("A web services callback binding cannot be used with a binding URI on a service: " + ((LogicalBindable)binding.getParent()).getUri());
        }
        if (targetUri != null) {
            if (!targetUri.isAbsolute() && !binding.isCallback()) {
                throw new Fabric3Exception("Web service binding URI must be absolute on reference: " + ((LogicalBindable)binding.getParent()).getUri());
            }
            try {
                targetUrl = targetUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        } else if (bindingDefinition.getWsdlElement() == null && bindingDefinition.getWsdlLocation() == null && !binding.isCallback()) {
            throw new Fabric3Exception("A web service binding URI must be specified: " + ((LogicalBindable)binding.getParent()).getUri());
        }
        return this.generateTarget(binding, targetUrl, contract);
    }

    @Override
    public MetroWireTarget generateServiceBindingTarget(LogicalBinding<WsBinding> binding, JavaServiceContract contract) {
        URL targetUrl = this.targetUrlResolver.resolveUrl(binding);
        return this.generateTarget(binding, targetUrl, contract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetroWireTarget generateTarget(LogicalBinding<WsBinding> binding, URL targetUrl, JavaServiceContract contract) {
        Class<?> serviceClass = contract.getInterfaceClass();
        WsBinding bindingDefinition = (WsBinding)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(bindingDefinition, serviceClass);
        ReferenceEndpointDefinition endpointDefinition = this.createEndpoint(binding, contract, serviceClass, targetUrl);
        Class<?> interfaze = contract.getInterfaceClass();
        List<PhysicalBindingHandler> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), bindingDefinition);
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                interfaze = serviceClass = generatedInterface.getGeneratedClass();
            }
            if (endpointDefinition.getWsdl() != null) {
                wsdl = endpointDefinition.getWsdl();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ConnectionConfiguration connectionConfiguration = GenerationHelper.createConnectionConfiguration(bindingDefinition);
        boolean bidirectional = contract.getCallbackContract() != null && !binding.isCallback();
        int retries = bindingDefinition.getRetries();
        MetroJavaWireTarget targetDefinition = new MetroJavaWireTarget(endpointDefinition, interfaze, wsdl, schemas, wsdlLocation, connectionConfiguration, retries, bidirectional, handlers);
        if (binding.isCallback()) {
            targetDefinition.setUri(((LogicalBindable)binding.getParent()).getUri());
        }
        return targetDefinition;
    }

    private URL getWsdlLocation(WsBinding definition, Class<?> serviceClass) {
        try {
            String location = definition.getWsdlLocation();
            if (location != null) {
                return new URL(location);
            }
            WebService annotation = serviceClass.getAnnotation(WebService.class);
            if (annotation != null) {
                String wsdlLocation = annotation.wsdlLocation();
                if (wsdlLocation.length() > 0) {
                    return new URL(wsdlLocation);
                }
                return null;
            }
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception((Throwable)e);
        }
        return null;
    }

    private ServiceEndpointDefinition createServiceEndpointDefinition(LogicalBinding<WsBinding> binding, JavaServiceContract contract, Class<?> serviceClass) {
        URI targetUri = ((WsBinding)binding.getDefinition()).getTargetUri();
        if (targetUri == null) {
            targetUri = URI.create(((LogicalBindable)binding.getParent()).getUri().getFragment());
        }
        return this.synthesizer.synthesizeServiceEndpoint(contract, serviceClass, targetUri);
    }

    private ReferenceEndpointDefinition createEndpoint(LogicalBinding<WsBinding> binding, JavaServiceContract contract, Class<?> serviceClass, URL targetUrl) {
        if (binding.isCallback()) {
            targetUrl = ReferenceEndpointDefinition.DYNAMIC_URL;
        }
        if (targetUrl != null) {
            return this.synthesizer.synthesizeReferenceEndpoint(contract, serviceClass, targetUrl);
        }
        throw new Fabric3Exception("Target URL must be specified");
    }
}

