/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java;

import java.net.URI;
import java.net.URL;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.java.EndpointSynthesizer;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.spi.model.type.java.JavaServiceContract;

public class EndpointSynthesizerImpl
implements EndpointSynthesizer {
    @Override
    public ReferenceEndpointDefinition synthesizeReferenceEndpoint(JavaServiceContract contract, Class<?> serviceClass, URL url) {
        WebService annotation = serviceClass.getAnnotation(WebService.class);
        if (annotation != null) {
            return this.createDefinition(annotation, serviceClass, url, null);
        }
        return this.createDefaultDefinition(serviceClass, url, null);
    }

    @Override
    public ServiceEndpointDefinition synthesizeServiceEndpoint(JavaServiceContract contract, Class<?> serviceClass, URI uri) {
        WebService annotation = serviceClass.getAnnotation(WebService.class);
        if (annotation != null) {
            return this.createDefinition(annotation, serviceClass, uri);
        }
        return this.createDefaultDefinition(serviceClass, uri);
    }

    private ReferenceEndpointDefinition createDefinition(WebService annotation, Class<?> serviceClass, URL url, QName portTypeQName) {
        String namespace = this.getNamespace(annotation, serviceClass);
        ServiceNameResult result = this.getServiceName(annotation, serviceClass, namespace);
        QName serviceQName = result.getServiceName();
        boolean defaultService = result.isDefaultServiceName();
        QName portQName = null;
        if (portTypeQName == null) {
            portTypeQName = this.getPortTypeName(annotation, serviceClass, namespace);
            portQName = this.getPortName(annotation, serviceClass, namespace);
        }
        return new ReferenceEndpointDefinition(serviceQName, defaultService, portQName, portTypeQName, url);
    }

    private ReferenceEndpointDefinition createDefaultDefinition(Class<?> serviceClass, URL url, QName portTypeQName) {
        String packageName = serviceClass.getPackage().getName();
        String className = serviceClass.getSimpleName();
        String namespace = this.deriveNamespace(packageName);
        QName serviceQName = new QName(namespace, className + "Service");
        QName portQName = null;
        if (portTypeQName == null) {
            portTypeQName = new QName(namespace, className);
            portQName = new QName(namespace, className + "Port");
        }
        return new ReferenceEndpointDefinition(serviceQName, true, portQName, portTypeQName, url);
    }

    private ServiceEndpointDefinition createDefinition(WebService annotation, Class<?> serviceClass, URI uri) {
        String namespace = this.getNamespace(annotation, serviceClass);
        ServiceNameResult result = this.getServiceName(annotation, serviceClass, namespace);
        QName serviceQName = result.getServiceName();
        QName portQName = this.getPortName(annotation, serviceClass, namespace);
        return new ServiceEndpointDefinition(serviceQName, portQName, uri);
    }

    private ServiceEndpointDefinition createDefaultDefinition(Class<?> serviceClass, URI uri) {
        String packageName = serviceClass.getPackage().getName();
        String className = serviceClass.getSimpleName();
        String namespace = this.deriveNamespace(packageName);
        QName serviceQName = new QName(namespace, className + "Service");
        QName portQName = new QName(namespace, className + "Port");
        return new ServiceEndpointDefinition(serviceQName, portQName, uri);
    }

    private String getNamespace(WebService annotation, Class<?> serviceClass) {
        String namespace = annotation.targetNamespace();
        if (namespace.length() < 1) {
            String packageName = serviceClass.getPackage().getName();
            namespace = this.deriveNamespace(packageName);
        }
        return namespace;
    }

    private ServiceNameResult getServiceName(WebService annotation, Class<?> serviceClass, String namespace) {
        boolean defaulted;
        String serviceName = annotation.serviceName();
        boolean bl = defaulted = serviceName.length() < 1;
        if (defaulted) {
            serviceName = serviceClass.getSimpleName() + "Service";
        }
        QName qName = new QName(namespace, serviceName);
        return new ServiceNameResult(qName, defaulted);
    }

    private QName getPortName(WebService annotation, Class<?> serviceClass, String namespace) {
        String portName = annotation.portName();
        if (portName.length() < 1) {
            portName = annotation.name().length() < 1 ? serviceClass.getSimpleName() + "Port" : annotation.name() + "Port";
        }
        return new QName(namespace, portName);
    }

    private QName getPortTypeName(WebService annotation, Class<?> serviceClass, String namespace) {
        String portTypeName = annotation.name();
        if (portTypeName.length() < 1) {
            portTypeName = serviceClass.getSimpleName();
        }
        return new QName(namespace, portTypeName);
    }

    String deriveNamespace(String pkg) {
        String[] tokens = pkg.split("\\.");
        StringBuilder builder = new StringBuilder("http://");
        for (int i = tokens.length - 1; i >= 0; --i) {
            String token = tokens[i];
            builder.append(token);
            if (i != 0) {
                builder.append(".");
                continue;
            }
            builder.append("/");
        }
        return builder.toString();
    }

    private class ServiceNameResult {
        private QName serviceName;
        private boolean defaultServiceName;

        private ServiceNameResult(QName serviceName, boolean defaultServiceName) {
            this.serviceName = serviceName;
            this.defaultServiceName = defaultServiceName;
        }

        public QName getServiceName() {
            return this.serviceName;
        }

        public boolean isDefaultServiceName() {
            return this.defaultServiceName;
        }
    }
}

