/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator;

import java.util.List;
import java.util.Map;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.ws.model.WsBinding;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.provision.MetroWireSource;
import org.fabric3.spi.domain.generator.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.api.binding.ws.model.WsBinding")
public class MetroWireBindingGenerator
implements WireBindingGenerator<WsBinding> {
    private Map<Class<?>, MetroGeneratorDelegate> delegates;

    @Reference
    public void setDelegates(Map<Class<?>, MetroGeneratorDelegate> delegates) {
        this.delegates = delegates;
    }

    public MetroWireSource generateSource(LogicalBinding<WsBinding> binding, ServiceContract contract, List<LogicalOperation> operations) throws Fabric3Exception {
        MetroGeneratorDelegate delegate = this.getDelegate(contract);
        return delegate.generateSource(binding, contract);
    }

    public PhysicalWireTarget generateTarget(LogicalBinding<WsBinding> binding, ServiceContract contract, List<LogicalOperation> operations) throws Fabric3Exception {
        MetroGeneratorDelegate delegate = this.getDelegate(contract);
        return delegate.generateTarget(binding, contract);
    }

    private MetroGeneratorDelegate getDelegate(ServiceContract contract) throws Fabric3Exception {
        MetroGeneratorDelegate delegate = this.delegates.get(contract.getClass());
        if (delegate == null) {
            throw new Fabric3Exception("Generator delegate not found for type: " + contract.getClass().getName());
        }
        return delegate;
    }
}

