/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fabric3.api.binding.ws.model.WsBinding;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.BindingHandler;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;

public class GenerationHelper {
    private GenerationHelper() {
    }

    public static ConnectionConfiguration createConnectionConfiguration(WsBinding binding) throws Fabric3Exception {
        ConnectionConfiguration configuration = new ConnectionConfiguration();
        Map configProperties = binding.getConfiguration();
        if (configProperties != null) {
            String clientStreamingChunkSize;
            String requestTimeout;
            String connectTimeout = (String)configProperties.get("connectTimeout");
            if (connectTimeout != null) {
                try {
                    configuration.setConnectTimeout(Integer.parseInt(connectTimeout));
                }
                catch (NumberFormatException e) {
                    throw new Fabric3Exception("Invalid connectTimeout", (Throwable)e);
                }
            }
            if ((requestTimeout = (String)configProperties.get("requestTimeout")) != null) {
                try {
                    configuration.setRequestTimeout(Integer.parseInt(requestTimeout));
                }
                catch (NumberFormatException e) {
                    throw new Fabric3Exception("Invalid requestTimeout", (Throwable)e);
                }
            }
            if ((clientStreamingChunkSize = (String)configProperties.get("clientStreamingChunkSize")) != null) {
                try {
                    configuration.setClientStreamingChunkSize(Integer.parseInt(clientStreamingChunkSize));
                }
                catch (NumberFormatException e) {
                    throw new Fabric3Exception("Invalid clientStreamingChunkSize", (Throwable)e);
                }
            }
        }
        return configuration;
    }

    public static List<PhysicalBindingHandler> generateBindingHandlers(URI domainUri, WsBinding binding) {
        ArrayList<PhysicalBindingHandler> handlers = new ArrayList<PhysicalBindingHandler>();
        for (BindingHandler handlerDefinition : binding.getHandlers()) {
            URI resolvedUri = URI.create(domainUri.toString() + "/" + handlerDefinition.getTarget());
            handlers.add(new PhysicalBindingHandler(resolvedUri));
        }
        return handlers;
    }
}

