/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.spi.runtime.connection;

import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionMonitor;
import org.fabric3.binding.jms.spi.runtime.connection.SingletonConnectionFactory;

public class XaSingletonConnectionFactory
extends SingletonConnectionFactory
implements XATopicConnectionFactory,
XAQueueConnectionFactory {
    public XaSingletonConnectionFactory(ConnectionFactory factory, ConnectionMonitor monitor) {
        super(factory, monitor);
        if (!(factory instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("Factory must implement XAConnectionFactory: " + factory.getClass().getName());
        }
    }

    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)this.createConnection();
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return (XAConnection)this.createConnection();
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createConnection();
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        throw new IllegalStateException(XaSingletonConnectionFactory.class.getName() + " does not support custom username and password");
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createConnection();
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        throw new IllegalStateException(XaSingletonConnectionFactory.class.getName() + " does not support custom username and password");
    }

    @Override
    protected List<Class> getConnectionInterfaces(Connection target) {
        List<Class> classes = super.getConnectionInterfaces(target);
        classes.add(XAConnection.class);
        if (target instanceof XATopicConnection) {
            classes.add(XATopicConnection.class);
        }
        if (target instanceof XAQueueConnection) {
            classes.add(XAQueueConnection.class);
        }
        return classes;
    }

    @Override
    protected Connection createSingletonConnection() throws JMSException {
        return ((XAConnectionFactory)this.targetFactory).createXAConnection();
    }
}

