/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.spi.runtime.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionMonitor;

public class SingletonConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ExceptionListener {
    protected ConnectionFactory targetFactory;
    private ConnectionMonitor monitor;
    protected Connection targetConnection;
    protected Connection proxiedConnection;
    protected boolean started = false;
    protected final Object sync = new Object();

    public SingletonConnectionFactory(ConnectionFactory factory, ConnectionMonitor monitor) {
        this.targetFactory = factory;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        Object object = this.sync;
        synchronized (object) {
            if (this.proxiedConnection == null) {
                this.init();
            }
            return this.proxiedConnection;
        }
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("Operation not supported");
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("Operation not supported");
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException(SingletonConnectionFactory.class.getName() + " does not support username and password");
    }

    public void onException(JMSException exception) {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws JMSException {
        Object object = this.sync;
        synchronized (object) {
            if (this.targetConnection != null) {
                this.closeConnection(this.targetConnection);
            }
            this.targetConnection = this.createSingletonConnection();
            this.targetConnection.setExceptionListener((ExceptionListener)this);
            this.proxiedConnection = this.proxyConnection(this.targetConnection);
        }
    }

    public void destroy() {
        this.resetConnection();
    }

    protected List<Class> getConnectionInterfaces(Connection target) {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Connection.class);
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        return classes;
    }

    protected Connection createSingletonConnection() throws JMSException {
        return this.targetFactory.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnection() {
        Object object = this.sync;
        synchronized (object) {
            if (this.targetConnection != null) {
                this.closeConnection(this.targetConnection);
            }
            this.targetConnection = null;
            this.proxiedConnection = null;
        }
    }

    private void closeConnection(Connection connection) {
        try {
            try {
                if (this.started) {
                    this.started = false;
                    connection.stop();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable e) {
            this.monitor.error(e);
        }
    }

    private Connection proxyConnection(Connection target) {
        List<Class> classes = this.getConnectionInterfaces(target);
        Class[] interfaces = classes.toArray(new Class[classes.size()]);
        ClassLoader classLoader = Connection.class.getClassLoader();
        ConnectionInvocationHandler handler = new ConnectionInvocationHandler(target);
        return (Connection)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public ConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("equals")) {
                return proxy == args[0];
            }
            if (name.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (name.equals("toString")) {
                return "Singleton connection proxy: " + this.target;
            }
            if (name.equals("setClientID")) {
                throw new IllegalStateException("setClientId() not supported on proxied connections");
            }
            if (name.equals("setExceptionListener")) {
                throw new IllegalStateException("setExceptionListener() not supported on proxied connections");
            }
            if (name.equals("start")) {
                Object object = SingletonConnectionFactory.this.sync;
                synchronized (object) {
                    if (!SingletonConnectionFactory.this.started) {
                        this.target.start();
                        SingletonConnectionFactory.this.started = true;
                    }
                }
                return null;
            }
            if (name.equals("stop")) {
                return null;
            }
            if (name.equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

