/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.wire;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.oasisopen.sca.ServiceRuntimeException;

public class ResponseListener {
    private Destination destination;
    private CorrelationScheme scheme;

    public ResponseListener(Destination destination, CorrelationScheme scheme) {
        this.destination = destination;
        this.scheme = scheme;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Message receive(String correlationId, Session session, long timeout) {
        try {
            MessageConsumer consumer;
            if (CorrelationScheme.MESSAGE_ID == this.scheme || CorrelationScheme.CORRELATION_ID == this.scheme) {
                String selector = "JMSCorrelationID = '" + correlationId + "'";
                consumer = session.createConsumer(this.destination, selector);
            } else {
                consumer = session.createConsumer(this.destination);
            }
            return consumer.receive(timeout);
        }
        catch (JMSException e) {
            throw new ServiceRuntimeException("Unable to receive response for message with correlation id: " + correlationId, (Throwable)e);
        }
    }
}

