/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.wire;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.wire.InterceptorConfiguration;
import org.fabric3.binding.jms.runtime.wire.JmsBadMessageException;
import org.fabric3.binding.jms.runtime.wire.MessageHelper;
import org.fabric3.binding.jms.runtime.wire.ResponseListener;
import org.fabric3.binding.jms.runtime.wire.WireConfiguration;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.container.binding.BindingHandler;
import org.fabric3.spi.container.invocation.CallbackReferenceSerializer;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageImpl;
import org.fabric3.spi.container.wire.Interceptor;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class JmsInterceptor
implements Interceptor {
    private static final String SCA_CALLBACK_DESTINATION = "scaCallbackDestination";
    private static final Message ONE_WAY_RESPONSE = new MessageImpl();
    private Interceptor next;
    private String methodName;
    private OperationPayloadTypes payloadTypes;
    private Destination destination;
    private Destination callbackDestination;
    private String callbackUri;
    private ConnectionFactory connectionFactory;
    private CorrelationScheme correlationScheme;
    private ResponseListener responseListener;
    private ClassLoader classLoader;
    private boolean oneWay;
    private SessionType sessionType;
    private TransactionManager tm;
    private long responseTimeout;
    private boolean persistent;
    private int deliveryMode;
    private long timeToLive;
    private String jmsType;
    private int priority;
    private Map<String, String> properties;
    private List<BindingHandler<javax.jms.Message>> handlers;

    public JmsInterceptor(InterceptorConfiguration configuration, List<BindingHandler<javax.jms.Message>> handlers) {
        WireConfiguration wireConfig = configuration.getWireConfiguration();
        this.destination = wireConfig.getRequestDestination();
        this.callbackDestination = wireConfig.getCallbackDestination();
        this.callbackUri = wireConfig.getCallbackUri();
        this.connectionFactory = wireConfig.getRequestConnectionFactory();
        this.correlationScheme = wireConfig.getCorrelationScheme();
        this.classLoader = wireConfig.getClassloader();
        this.responseListener = wireConfig.getResponseListener();
        this.tm = wireConfig.getTransactionManager();
        this.sessionType = wireConfig.getSessionType();
        this.responseTimeout = wireConfig.getResponseTimeout();
        this.persistent = wireConfig.isPersistent();
        this.oneWay = configuration.isOneWay();
        this.methodName = configuration.getOperationName();
        this.payloadTypes = configuration.getPayloadTypes();
        this.deliveryMode = configuration.getDeliveryMode();
        this.timeToLive = configuration.getTimeToLive();
        this.jmsType = configuration.getJmsType();
        this.priority = configuration.getPriority();
        this.properties = configuration.getProperties();
        this.handlers = handlers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message invoke(Message message) {
        Message message2;
        boolean begun;
        Transaction suspended;
        ClassLoader oldCl;
        Session session;
        Connection connection;
        block18: {
            connection = null;
            session = null;
            oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.connectionFactory.getClass().getClassLoader());
            connection = this.connectionFactory.createConnection();
            connection.start();
            int status = this.tm.getStatus();
            suspended = null;
            begun = false;
            if (6 == status && SessionType.GLOBAL_TRANSACTED == this.sessionType) {
                this.tm.begin();
                begun = true;
            } else if (0 == status && (SessionType.AUTO_ACKNOWLEDGE == this.sessionType || SessionType.CLIENT_ACKNOWLEDGE == this.sessionType)) {
                suspended = this.tm.suspend();
            }
            session = SessionType.GLOBAL_TRANSACTED == this.sessionType ? connection.createSession(true, 0) : connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            if (!this.persistent || 1 == this.deliveryMode) {
                producer.setDeliveryMode(1);
            }
            if (this.timeToLive >= 0L) {
                producer.setTimeToLive(this.timeToLive);
            }
            javax.jms.Message jmsMessage = this.createMessage(message, session);
            this.setHeaders(jmsMessage);
            String correlationId = null;
            if (this.correlationScheme == CorrelationScheme.CORRELATION_ID) {
                correlationId = UUID.randomUUID().toString();
                jmsMessage.setJMSCorrelationID(correlationId);
            }
            this.applyHandlers(message, jmsMessage);
            producer.send(jmsMessage);
            if (this.correlationScheme == CorrelationScheme.MESSAGE_ID) {
                correlationId = jmsMessage.getJMSMessageID();
            }
            if (this.oneWay) break block18;
            Message resp = this.receive(correlationId, session, message);
            if (begun) {
                this.tm.commit();
            }
            if (suspended != null) {
                this.tm.resume(suspended);
            }
            Message message3 = resp;
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
            Thread.currentThread().setContextClassLoader(oldCl);
            return message3;
        }
        try {
            if (begun) {
                this.tm.commit();
            }
            if (suspended != null) {
                this.tm.resume(suspended);
            }
            message2 = ONE_WAY_RESPONSE;
        }
        catch (JMSException | JmsBadMessageException e) {
            try {
                throw new ServiceRuntimeException("Unable to receive response", (Throwable)e);
                catch (IOException e2) {
                    throw new ServiceRuntimeException("Error serializing callback references", (Throwable)e2);
                }
                catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e3) {
                    throw new ServiceRuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
        Thread.currentThread().setContextClassLoader(oldCl);
        return message2;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receive(String correlationId, Session session, Message message) throws JMSException, JmsBadMessageException {
        javax.jms.Message resultMessage = this.responseListener.receive(correlationId, session, this.responseTimeout);
        if (resultMessage == null) {
            throw new ServiceUnavailableException("Timeout waiting for response to message: " + correlationId);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (resultMessage.getBooleanProperty("f3Fault")) {
                Object payload = MessageHelper.getPayload(resultMessage, this.payloadTypes.getFaultType());
                message.setBodyWithFault(payload);
            } else {
                Object payload = MessageHelper.getPayload(resultMessage, this.payloadTypes.getOutputType());
                message.setBody(payload);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return message;
    }

    private javax.jms.Message createMessage(Message message, Session session) throws JMSException, IOException {
        Object[] payload = (Object[])message.getBody();
        switch (this.payloadTypes.getInputType()) {
            case OBJECT: {
                ObjectMessage jmsMessage = session.createObjectMessage((Serializable)payload);
                this.setRoutingHeaders(message, (javax.jms.Message)jmsMessage);
                return jmsMessage;
            }
            case STREAM: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            case TEXT: {
                if (payload.length != 1) {
                    throw new UnsupportedOperationException("Only single parameter operations are supported");
                }
                TextMessage jmsMessage = session.createTextMessage((String)payload[0]);
                this.setRoutingHeaders(message, (javax.jms.Message)jmsMessage);
                return jmsMessage;
            }
        }
        if (payload.length != 1) {
            throw new AssertionError((Object)"Bytes messages must have a single parameter");
        }
        javax.jms.Message jmsMessage = MessageHelper.createBytesMessage(session, payload[0], this.payloadTypes.getInputType());
        this.setRoutingHeaders(message, jmsMessage);
        return jmsMessage;
    }

    private void setHeaders(javax.jms.Message message) throws JMSException {
        message.setStringProperty("scaOperationName", this.methodName);
        if (!this.oneWay) {
            message.setJMSReplyTo(this.responseListener.getDestination());
        }
        if (this.priority >= 0) {
            message.setJMSPriority(this.priority);
        }
        if (this.jmsType != null) {
            message.setJMSType(this.jmsType);
        }
        if (!this.properties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                message.setStringProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.callbackDestination != null) {
            if (this.oneWay) {
                message.setJMSReplyTo(this.callbackDestination);
            } else {
                message.setStringProperty(SCA_CALLBACK_DESTINATION, this.callbackUri);
            }
        }
    }

    private void setRoutingHeaders(Message message, javax.jms.Message jmsMessage) throws JMSException, IOException {
        List stack = message.getWorkContext().getCallbackReferences();
        if (stack == null || stack.isEmpty()) {
            return;
        }
        jmsMessage.setObjectProperty("f3Context", (Object)CallbackReferenceSerializer.serializeToString((List)stack));
    }

    private void applyHandlers(Message message, javax.jms.Message jmsMessage) {
        if (this.handlers != null) {
            for (BindingHandler<javax.jms.Message> handler : this.handlers) {
                handler.handleOutbound(message, (Object)jmsMessage);
            }
        }
    }
}

