/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.destination;

import java.util.List;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.fabric3.binding.jms.spi.runtime.provider.DestinationResolver;
import org.oasisopen.sca.annotation.Reference;

@Key(value="NEVER")
public class NeverDestinationStrategy
implements DestinationStrategy {
    private List<DestinationResolver> resolvers;

    @Reference(required=false)
    public void setResolvers(List<DestinationResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public javax.jms.Destination getDestination(Destination definition, ConnectionFactory factory) throws Fabric3Exception {
        for (DestinationResolver resolver : this.resolvers) {
            Optional<javax.jms.Destination> destination = resolver.resolve(definition);
            if (!destination.isPresent()) continue;
            return destination.get();
        }
        throw new Fabric3Exception("Destination not found: " + definition.getName());
    }
}

