/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.List;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryResolver;
import org.oasisopen.sca.annotation.Reference;

@Key(value="NEVER")
public class NeverConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;
    private List<ConnectionFactoryResolver> resolvers;

    public NeverConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws Fabric3Exception {
        String name = definition.getName();
        ConnectionFactory factory = this.manager.get(name);
        if (factory != null) {
            return factory;
        }
        for (ConnectionFactoryResolver resolver : this.resolvers) {
            Optional<ConnectionFactory> optional = resolver.resolve(definition);
            if (!optional.isPresent()) continue;
            return this.manager.register(name, optional.get(), definition.getProperties());
        }
        throw new Fabric3Exception("Unable to resolve ConnectionFactory: " + name);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) {
    }
}

