/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.oasisopen.sca.annotation.Reference;

public class AdministeredObjectResolverImpl
implements AdministeredObjectResolver {
    private Map<CreateOption, ConnectionFactoryStrategy> factoryStrategies = new HashMap<CreateOption, ConnectionFactoryStrategy>();
    private Map<CreateOption, DestinationStrategy> destinationStrategies = new HashMap<CreateOption, DestinationStrategy>();

    public AdministeredObjectResolverImpl(@Reference Map<CreateOption, ConnectionFactoryStrategy> factoryStrategies, @Reference Map<CreateOption, DestinationStrategy> destinationStrategies) {
        this.factoryStrategies = factoryStrategies;
        this.destinationStrategies = destinationStrategies;
    }

    @Override
    public ConnectionFactory resolve(ConnectionFactoryDefinition definition) throws Fabric3Exception {
        CreateOption create = definition.getCreate();
        ConnectionFactoryStrategy strategy = this.getConnectionFactory(create);
        return strategy.getConnectionFactory(definition);
    }

    @Override
    public javax.jms.Destination resolve(Destination destination, ConnectionFactory factory) throws Fabric3Exception {
        CreateOption create = destination.getCreate();
        DestinationStrategy strategy = this.destinationStrategies.get(create);
        if (strategy == null) {
            throw new AssertionError((Object)("DestinationStrategy not configured: " + create));
        }
        return strategy.getDestination(destination, factory);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws Fabric3Exception {
        CreateOption create = definition.getCreate();
        ConnectionFactoryStrategy strategy = this.getConnectionFactory(create);
        strategy.release(definition);
    }

    private ConnectionFactoryStrategy getConnectionFactory(CreateOption create) {
        ConnectionFactoryStrategy strategy = this.factoryStrategies.get(create);
        if (strategy == null) {
            throw new AssertionError((Object)("ConnectionFactoryStrategy not configured: " + create));
        }
        return strategy;
    }
}

