/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.jndi;

import java.util.Optional;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryResolver;
import org.fabric3.binding.jms.spi.runtime.provider.DestinationResolver;
import org.fabric3.jndi.spi.JndiContextManager;
import org.oasisopen.sca.annotation.Reference;

public class JndiAdministeredObjectResolver
implements ConnectionFactoryResolver,
DestinationResolver {
    private JndiContextManager contextManager;
    private ConnectionFactoryManager factoryManager;

    public JndiAdministeredObjectResolver(@Reference JndiContextManager contextManager, @Reference ConnectionFactoryManager factoryManager) {
        this.contextManager = contextManager;
        this.factoryManager = factoryManager;
    }

    @Override
    public Optional<ConnectionFactory> resolve(ConnectionFactoryDefinition definition) throws Fabric3Exception {
        try {
            String name = definition.getName();
            ConnectionFactory factory = (ConnectionFactory)this.contextManager.lookup(ConnectionFactory.class, name);
            if (factory == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.factoryManager.register(name, factory, definition.getProperties()));
        }
        catch (NamingException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    @Override
    public Optional<javax.jms.Destination> resolve(Destination definition) throws Fabric3Exception {
        try {
            return Optional.ofNullable(this.contextManager.lookup(javax.jms.Destination.class, definition.getName()));
        }
        catch (NamingException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }
}

