/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.ContainerManagerMonitor;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.TransportStart;
import org.fabric3.spi.runtime.event.TransportStop;
import org.fabric3.spi.transport.Transport;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@EagerInit
@Service(value={MessageContainerManager.class, Transport.class})
public class MessageContainerManagerImpl
implements MessageContainerManager,
Transport {
    private Map<URI, AdaptiveMessageContainer> containers = new ConcurrentHashMap<URI, AdaptiveMessageContainer>();
    private boolean started;
    private boolean pausedOnStart;
    private EventService eventService;
    private ManagementService managementService;
    private ContainerManagerMonitor managerMonitor;

    public MessageContainerManagerImpl(@Reference EventService eventService, @Reference ManagementService managementService, @Monitor ContainerManagerMonitor managerMonitor) {
        this.eventService = eventService;
        this.managementService = managementService;
        this.managerMonitor = managerMonitor;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:jms/@pause.on.start")
    public void setPauseOnStart(boolean pauseOnStart) {
        this.pausedOnStart = pauseOnStart;
    }

    @Init
    public void init() {
        this.eventService.subscribe(TransportStart.class, (Fabric3EventListener)new StartEventListener());
        this.eventService.subscribe(TransportStop.class, (Fabric3EventListener)new StopEventListener());
    }

    @Destroy
    public void destroy() throws JMSException {
        this.started = false;
    }

    public void suspend() {
        if (!this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            entry.getValue().stop();
        }
        this.started = false;
    }

    public void resume() {
        if (this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                if (this.pausedOnStart) {
                    entry.getValue().initialize();
                    continue;
                }
                entry.getValue().start();
            }
            catch (Fabric3Exception e) {
                this.managerMonitor.startError(entry.getKey(), e);
            }
        }
        this.pausedOnStart = false;
        this.started = true;
    }

    @Override
    public boolean isRegistered(URI serviceUri) {
        return this.containers.containsKey(serviceUri);
    }

    @Override
    public void register(AdaptiveMessageContainer container) throws Fabric3Exception {
        URI uri = container.getContainerUri();
        this.containers.put(uri, container);
        String encodedName = this.encodeName(uri);
        String encodedGroup = this.encodeGroup(uri);
        this.managementService.export(encodedName, encodedGroup, "JMS message container", (Object)container);
        if (this.started) {
            container.initialize();
            this.managerMonitor.registerListener(uri);
        }
    }

    @Override
    public void unregister(URI uri) throws Fabric3Exception {
        AdaptiveMessageContainer container = this.containers.remove(uri);
        if (container != null) {
            container.shutdown();
            String encodedName = this.encodeName(uri);
            String encodedGroup = this.encodeGroup(uri);
            this.managementService.remove(encodedName, encodedGroup);
            this.managerMonitor.unRegisterListener(uri);
        }
    }

    private String encodeName(URI uri) {
        return "transports/jms/consumers/" + UriHelper.getBaseName((URI)uri).replace("#", "/").toLowerCase();
    }

    private String encodeGroup(URI uri) {
        String path = uri.getPath();
        if (path.length() != 0) {
            return "JMS/message containers/" + path.substring(1);
        }
        return "JMS/message containers/" + uri.getAuthority();
    }

    private class StopEventListener
    implements Fabric3EventListener<TransportStop> {
        private StopEventListener() {
        }

        public void onEvent(TransportStop event) {
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                ((AdaptiveMessageContainer)entry.getValue()).stop();
            }
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                ((AdaptiveMessageContainer)entry.getValue()).shutdown();
            }
        }
    }

    private class StartEventListener
    implements Fabric3EventListener<TransportStart> {
        private StartEventListener() {
        }

        public void onEvent(TransportStart event) {
            for (Map.Entry entry : MessageContainerManagerImpl.this.containers.entrySet()) {
                try {
                    if (!MessageContainerManagerImpl.this.pausedOnStart) {
                        ((AdaptiveMessageContainer)entry.getValue()).initialize();
                    }
                    MessageContainerManagerImpl.this.managerMonitor.registerListener((URI)entry.getKey());
                }
                catch (Fabric3Exception e) {
                    MessageContainerManagerImpl.this.managerMonitor.startError((URI)entry.getKey(), e);
                }
            }
            if (!MessageContainerManagerImpl.this.pausedOnStart) {
                MessageContainerManagerImpl.this.started = true;
            }
        }
    }
}

