/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import javax.transaction.TransactionManager;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.AutoAckUnitOfWork;
import org.fabric3.binding.jms.runtime.container.ClientAckUnitOfWork;
import org.fabric3.binding.jms.runtime.container.ConnectionManager;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.JtaUnitOfWork;
import org.fabric3.binding.jms.runtime.container.LocalTransactionUnitOfWork;
import org.fabric3.binding.jms.runtime.container.MessageContainerFactory;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class MessageContainerFactoryImpl
implements MessageContainerFactory {
    private static final int DEFAULT_TRX_TIMEOUT = 30;
    private ExecutorService executorService;
    private TransactionManager tm;
    private MessageContainerMonitor containerMonitor;
    private HostInfo hostInfo;
    private int transactionTimeout = 30;

    @Property(required=false)
    @Source(value="$systemConfig//f3:jms/@transaction.timeout")
    public void setTransactionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Invalid transaction timeout: " + timeout);
        }
        this.transactionTimeout = timeout;
    }

    public MessageContainerFactoryImpl(@Reference(name="executorService") ExecutorService executorService, @Reference TransactionManager tm, @Reference HostInfo hostInfo, @Monitor MessageContainerMonitor containerMonitor) {
        this.executorService = executorService;
        this.tm = tm;
        this.hostInfo = hostInfo;
        this.containerMonitor = containerMonitor;
    }

    @Override
    public AdaptiveMessageContainer create(ContainerConfiguration configuration) {
        ConnectionFactory factory = configuration.getFactory();
        SessionType type = configuration.getSessionType();
        boolean durable = configuration.isDurable();
        int cacheLevel = configuration.getCacheLevel();
        boolean cacheConnection = cacheLevel >= 1;
        int receiveTimeout = this.transactionTimeout / 2 * 500;
        ContainerStatistics statistics = new ContainerStatistics();
        URI uri = configuration.getUri();
        ConnectionManager connectionManager = new ConnectionManager(factory, uri, cacheConnection, durable, this.containerMonitor);
        UnitOfWork work = this.createWork(uri, type, statistics);
        boolean javaEE = this.hostInfo.isJavaEEXAEnabled();
        return new AdaptiveMessageContainer(configuration, receiveTimeout, connectionManager, work, statistics, this.executorService, javaEE, this.containerMonitor);
    }

    private UnitOfWork createWork(URI uri, SessionType type, ContainerStatistics statistics) {
        switch (type) {
            case GLOBAL_TRANSACTED: {
                return new JtaUnitOfWork(uri, this.transactionTimeout, this.tm, statistics);
            }
            case LOCAL_TRANSACTED: {
                return new LocalTransactionUnitOfWork(uri, statistics);
            }
            case CLIENT_ACKNOWLEDGE: {
                return new ClientAckUnitOfWork(uri);
            }
        }
        return new AutoAckUnitOfWork();
    }
}

