/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;

public class LocalTransactionUnitOfWork
implements UnitOfWork {
    private URI uri;
    private ContainerStatistics statistics;

    public LocalTransactionUnitOfWork(URI uri, ContainerStatistics statistics) {
        this.uri = uri;
        this.statistics = statistics;
    }

    @Override
    public void begin() {
    }

    @Override
    public void end(Session session, Message message) throws Fabric3Exception {
        try {
            session.commit();
        }
        catch (JMSException e) {
            throw new Fabric3Exception("Error handling message for " + this.uri, (Throwable)e);
        }
        this.statistics.incrementTransactions();
    }

    @Override
    public void rollback(Session session) throws Fabric3Exception {
        try {
            session.rollback();
        }
        catch (JMSException e) {
            throw new Fabric3Exception("Error handling message for " + this.uri, (Throwable)e);
        }
        this.statistics.incrementTransactionsRolledBack();
    }
}

