/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import javax.jms.Message;
import javax.jms.Session;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;

public class JtaUnitOfWork
implements UnitOfWork {
    private URI uri;
    private int transactionTimeout;
    private TransactionManager tm;
    private ContainerStatistics statistics;

    public JtaUnitOfWork(URI uri, int timeout, TransactionManager tm, ContainerStatistics statistics) {
        this.uri = uri;
        this.transactionTimeout = timeout;
        this.tm = tm;
        this.statistics = statistics;
    }

    @Override
    public void begin() throws Fabric3Exception {
        try {
            this.tm.begin();
            this.tm.setTransactionTimeout(this.transactionTimeout);
        }
        catch (NotSupportedException | SystemException e) {
            throw new Fabric3Exception(e);
        }
    }

    @Override
    public void end(Session session, Message message) throws Fabric3Exception {
        try {
            if (this.tm.getStatus() != 1) {
                this.tm.commit();
                this.statistics.incrementTransactions();
            } else {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (IllegalStateException | SecurityException | HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new Fabric3Exception("Error handling message for " + this.uri, e);
        }
    }

    @Override
    public void rollback(Session session) throws Fabric3Exception {
        try {
            if (this.tm.getStatus() != 6) {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (SystemException e) {
            throw new Fabric3Exception("Error reverting transaction for " + this.uri, (Throwable)e);
        }
    }
}

