/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ContainerStatistics {
    private long start;
    private AtomicLong messagesReceived = new AtomicLong();
    private AtomicInteger maxReceivers = new AtomicInteger();
    private AtomicInteger transactions = new AtomicInteger();
    private AtomicInteger transactionsRolledBack = new AtomicInteger();

    public ContainerStatistics() {
        this.start = System.currentTimeMillis();
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this.start;
    }

    public long getMessagesReceived() {
        return this.messagesReceived.get();
    }

    public void incrementMessagesReceived() {
        this.messagesReceived.incrementAndGet();
    }

    public int getMaxReceivers() {
        return this.maxReceivers.get();
    }

    public void incrementMaxReceivers() {
        this.maxReceivers.incrementAndGet();
    }

    public int getTransactions() {
        return this.transactions.get();
    }

    public void incrementTransactions() {
        this.transactions.incrementAndGet();
    }

    public int getTransactionsRolledBack() {
        return this.transactionsRolledBack.get();
    }

    public void incrementTransactionsRolledBack() {
        this.transactionsRolledBack.incrementAndGet();
    }
}

