/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;

public class ConnectionManager {
    private URI listenerUri;
    private ConnectionFactory connectionFactory;
    private boolean cacheConnection;
    private boolean durable;
    private MessageContainerMonitor monitor;
    private Connection sharedConnection;
    private boolean sharedConnectionStarted = false;

    public ConnectionManager(ConnectionFactory connectionFactory, URI listenerUri, boolean cacheConnection, boolean durable, MessageContainerMonitor monitor) {
        this.listenerUri = listenerUri;
        this.connectionFactory = connectionFactory;
        this.cacheConnection = cacheConnection;
        this.durable = durable;
        this.monitor = monitor;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void start() throws Fabric3Exception {
        if (this.cacheConnection) {
            this.getSharedConnection();
        }
    }

    public Connection getConnection() throws Fabric3Exception {
        if (this.cacheConnection) {
            return this.getSharedConnection();
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.connectionFactory.getClass().getClassLoader());
            Connection connection = this.connectionFactory.createConnection();
            connection.start();
            Connection connection2 = connection;
            return connection2;
        }
        catch (JMSException e) {
            throw new Fabric3Exception((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void close() {
        JmsHelper.closeQuietly(this.sharedConnection);
        this.sharedConnection = null;
    }

    private synchronized Connection getSharedConnection() throws Fabric3Exception {
        if (this.sharedConnection == null) {
            this.sharedConnection = this.createSharedConnection();
        }
        return this.sharedConnection;
    }

    private Connection createSharedConnection() throws Fabric3Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Connection connection = null;
        try {
            Thread.currentThread().setContextClassLoader(this.connectionFactory.getClass().getClassLoader());
            Connection connection2 = connection = this.connectionFactory.createConnection();
            return connection2;
        }
        catch (JMSException ex) {
            JmsHelper.closeQuietly(connection);
            throw new Fabric3Exception((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void startSharedConnection() {
        try {
            this.sharedConnectionStarted = true;
            if (this.sharedConnection != null) {
                this.sharedConnection.start();
            }
        }
        catch (JMSException e) {
            this.monitor.startConnectionError(e);
        }
    }

    public synchronized void stopSharedConnection() {
        try {
            this.sharedConnectionStarted = false;
            if (this.sharedConnection != null) {
                this.sharedConnection.stop();
            }
        }
        catch (Exception e) {
            this.monitor.stopConnectionError(this.listenerUri, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean refreshConnection() {
        try {
            if (this.cacheConnection) {
                this.refreshSharedConnection();
                return true;
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Connection con = null;
            try {
                Thread.currentThread().setContextClassLoader(this.connectionFactory.getClass().getClassLoader());
                con = this.connectionFactory.createConnection();
                Thread.currentThread().setContextClassLoader(old);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(old);
                JmsHelper.closeQuietly(con);
                throw throwable;
            }
            JmsHelper.closeQuietly(con);
            return true;
        }
        catch (Exception e) {
            this.monitor.connectionError(this.listenerUri.toString(), e);
            return false;
        }
    }

    private synchronized void refreshSharedConnection() throws Fabric3Exception {
        JmsHelper.closeQuietly(this.sharedConnection);
        this.sharedConnection = this.createSharedConnection();
        if (this.sharedConnectionStarted) {
            try {
                this.sharedConnection.start();
            }
            catch (JMSException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
    }
}

