/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.transaction.TransactionManager;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.HeadersDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.OperationPropertiesDefinition;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.binding.jms.runtime.DataTypeHelper;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.runtime.wire.InterceptorConfiguration;
import org.fabric3.binding.jms.runtime.wire.JmsInterceptor;
import org.fabric3.binding.jms.runtime.wire.ResponseListener;
import org.fabric3.binding.jms.runtime.wire.WireConfiguration;
import org.fabric3.binding.jms.spi.provision.JmsWireTarget;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.spi.container.binding.BindingHandler;
import org.fabric3.spi.container.binding.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.TransformerInterceptorFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.binding.jms.spi.provision.JmsWireTarget")
public class JmsTargetWireAttacher
implements TargetWireAttacher<JmsWireTarget> {
    private AdministeredObjectResolver resolver;
    private TransactionManager tm;
    private BindingHandlerRegistry handlerRegistry;
    private TransformerInterceptorFactory interceptorFactory;

    public JmsTargetWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference TransactionManager tm, @Reference BindingHandlerRegistry handlerRegistry, @Reference TransformerInterceptorFactory interceptorFactory) {
        this.resolver = resolver;
        this.tm = tm;
        this.handlerRegistry = handlerRegistry;
        this.interceptorFactory = interceptorFactory;
    }

    public void attach(PhysicalWireSource source, JmsWireTarget target, Wire wire) {
        WireConfiguration wireConfiguration = new WireConfiguration();
        ClassLoader targetClassLoader = target.getClassLoader();
        wireConfiguration.setClassloader(targetClassLoader);
        wireConfiguration.setTransactionManager(this.tm);
        wireConfiguration.setCorrelationScheme(target.getMetadata().getCorrelationScheme());
        wireConfiguration.setResponseTimeout(target.getMetadata().getResponseTimeout());
        wireConfiguration.setSessionType(target.getSessionType());
        JmsBindingMetadata metadata = target.getMetadata();
        HeadersDefinition headers = metadata.getHeaders();
        boolean persistent = DeliveryMode.PERSISTENT == headers.getDeliveryMode() || headers.getDeliveryMode() == null;
        wireConfiguration.setPersistent(persistent);
        this.resolveAdministeredObjects(target, wireConfiguration);
        List<BindingHandler<Message>> handlers = this.createHandlers(target);
        List<OperationPayloadTypes> types = target.getPayloadTypes();
        for (InvocationChain chain : wire.getInvocationChains()) {
            InterceptorConfiguration configuration = new InterceptorConfiguration(wireConfiguration);
            PhysicalOperation physicalOperation = chain.getPhysicalOperation();
            String operationName = physicalOperation.getName();
            configuration.setOperationName(operationName);
            configuration.setOneWay(physicalOperation.isOneWay());
            this.processJmsHeaders(configuration, metadata);
            OperationPayloadTypes payloadTypes = this.resolveOperation(operationName, types);
            configuration.setPayloadType(payloadTypes);
            if (target.getDataTypes().contains(PhysicalDataTypes.JAXB)) {
                this.addJAXBInterceptor(source, physicalOperation, chain, targetClassLoader);
            }
            JmsInterceptor interceptor = new JmsInterceptor(configuration, handlers);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalWireSource source, JmsWireTarget target) {
        this.resolver.release(target.getMetadata().getConnectionFactory());
    }

    private void processJmsHeaders(InterceptorConfiguration configuration, JmsBindingMetadata metadata) {
        HeadersDefinition uriHeaders = metadata.getUriHeaders();
        HeadersDefinition headers = metadata.getHeaders();
        Map properties = metadata.getOperationProperties();
        this.setBindingHeaders(configuration, uriHeaders);
        OperationPropertiesDefinition definition = (OperationPropertiesDefinition)properties.get(configuration.getOperationName());
        if (definition != null) {
            this.setOperationHeaders(configuration, definition);
        }
        this.setBindingHeaders(configuration, headers);
    }

    private void setBindingHeaders(InterceptorConfiguration configuration, HeadersDefinition headers) {
        long timeToLive;
        int priority;
        DeliveryMode deliveryMode;
        String type = headers.getJmsType();
        if (type != null && configuration.getJmsType() != null) {
            configuration.setJmsType(type);
        }
        if ((deliveryMode = headers.getDeliveryMode()) != null && configuration.getDeliveryMode() == -1) {
            this.setDeliveryMode(deliveryMode.toString(), configuration);
        }
        if ((priority = headers.getPriority()) >= 0 && configuration.getPriority() == -1) {
            configuration.setPriority(priority);
        }
        if ((timeToLive = headers.getTimeToLive()) >= 0L && configuration.getTimeToLive() == -1L) {
            configuration.setTimeToLive(timeToLive);
        }
        for (Map.Entry entry : headers.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (configuration.getProperties().containsKey(key)) continue;
            configuration.addProperty(key, value);
        }
    }

    private void setOperationHeaders(InterceptorConfiguration configuration, OperationPropertiesDefinition definition) {
        for (Map.Entry entry : definition.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (configuration.getJmsType() == null && "JMSType".equals(key)) {
                if (configuration.getJmsType() == null) continue;
                configuration.setJmsType(value);
                continue;
            }
            if (configuration.getDeliveryMode() == -1 && "JMSDeliveryMode".equals(key)) {
                this.setDeliveryMode(value, configuration);
                continue;
            }
            if (configuration.getTimeToLive() == -1L && "JMSTimeToLive".equals(key)) {
                try {
                    long time = Long.valueOf(value);
                    configuration.setTimeToLive(time);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Fabric3Exception((Throwable)e);
                }
            }
            if (configuration.getPriority() == -1 && "JMSPriority".equals(key)) {
                try {
                    int priority = Integer.valueOf(value);
                    configuration.setPriority(priority);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Fabric3Exception((Throwable)e);
                }
            }
            configuration.addProperty(key, value);
        }
    }

    private void setDeliveryMode(String value, InterceptorConfiguration configuration) {
        if ("persistent".equalsIgnoreCase(value)) {
            configuration.setDeliveryMode(2);
        } else if ("nonpersistent".equalsIgnoreCase(value)) {
            configuration.setDeliveryMode(1);
        }
    }

    private void addJAXBInterceptor(PhysicalWireSource source, PhysicalOperation op, InvocationChain chain, ClassLoader targetClassLoader) {
        ClassLoader sourceClassLoader = source.getClassLoader();
        List<DataType> jaxTypes = DataTypeHelper.createTypes(op);
        Interceptor jaxbInterceptor = this.interceptorFactory.createInterceptor(op, jaxTypes, DataTypeHelper.JAXB_TYPES, targetClassLoader, sourceClassLoader);
        chain.addInterceptor(jaxbInterceptor);
    }

    private void resolveAdministeredObjects(JmsWireTarget target, WireConfiguration wireConfiguration) {
        JmsBindingMetadata metadata = target.getMetadata();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        try {
            Destination callbackDestinationDefinition;
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(connectionFactoryDefinition);
            Destination destination = metadata.getDestination();
            javax.jms.Destination requestDestination = this.resolver.resolve(destination, requestConnectionFactory);
            wireConfiguration.setRequestConnectionFactory(requestConnectionFactory);
            wireConfiguration.setRequestDestination(requestDestination);
            this.validateDestination(requestDestination, destination);
            if (metadata.isResponse()) {
                connectionFactoryDefinition = metadata.getResponseConnectionFactory();
                ConnectionFactory responseConnectionFactory = this.resolver.resolve(connectionFactoryDefinition);
                destination = metadata.getResponseDestination();
                javax.jms.Destination responseDestination = this.resolver.resolve(destination, responseConnectionFactory);
                CorrelationScheme scheme = metadata.getCorrelationScheme();
                ResponseListener listener = new ResponseListener(responseDestination, scheme);
                wireConfiguration.setResponseListener(listener);
                this.validateDestination(responseDestination, destination);
            }
            if ((callbackDestinationDefinition = target.getCallbackDestination()) != null) {
                javax.jms.Destination callbackDestination = this.resolver.resolve(callbackDestinationDefinition, requestConnectionFactory);
                wireConfiguration.setCallbackDestination(callbackDestination);
                if (callbackDestination != null) {
                    String name;
                    if (callbackDestination instanceof Queue) {
                        name = ((Queue)callbackDestination).getQueueName();
                        wireConfiguration.setCallbackUri("jms:" + name);
                    } else if (callbackDestination instanceof Topic) {
                        name = ((Topic)callbackDestination).getTopicName();
                        wireConfiguration.setCallbackUri("jms:" + name);
                    }
                }
            }
        }
        catch (JMSException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private void validateDestination(javax.jms.Destination requestDestination, Destination requestDestinationDefinition) {
        DestinationType requestDestinationType = requestDestinationDefinition.geType();
        if (DestinationType.QUEUE == requestDestinationType && !(requestDestination instanceof Queue)) {
            throw new Fabric3Exception("Destination is not a queue: " + requestDestinationDefinition.getName());
        }
        if (DestinationType.TOPIC == requestDestinationType && !(requestDestination instanceof Topic)) {
            throw new Fabric3Exception("Destination is not a topic: " + requestDestinationDefinition.getName());
        }
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private List<BindingHandler<Message>> createHandlers(JmsWireTarget target) {
        if (target.getHandlers().isEmpty()) {
            return null;
        }
        ArrayList<BindingHandler<Message>> handlers = new ArrayList<BindingHandler<Message>>();
        for (PhysicalBindingHandler physicalHandler : target.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(Message.class, physicalHandler);
            handlers.add((BindingHandler<Message>)handler);
        }
        return handlers;
    }
}

