/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.binding.jms.runtime.DataTypeHelper;
import org.fabric3.binding.jms.runtime.common.ListenerMonitor;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.MessageContainerFactory;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.runtime.wire.InvocationChainHolder;
import org.fabric3.binding.jms.runtime.wire.ServiceListener;
import org.fabric3.binding.jms.runtime.wire.WireHolder;
import org.fabric3.binding.jms.spi.provision.JmsWireSource;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.container.binding.BindingHandler;
import org.fabric3.spi.container.binding.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.TransformerInterceptorFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.binding.jms.spi.provision.JmsWireSource")
public class JmsSourceWireAttacher
implements SourceWireAttacher<JmsWireSource> {
    private AdministeredObjectResolver resolver;
    private MessageContainerFactory containerFactory;
    private MessageContainerManager containerManager;
    private TransformerInterceptorFactory interceptorFactory;
    private ListenerMonitor monitor;
    private BindingHandlerRegistry handlerRegistry;

    public JmsSourceWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference MessageContainerFactory containerFactory, @Reference MessageContainerManager containerManager, @Reference BindingHandlerRegistry handlerRegistry, @Reference TransformerInterceptorFactory interceptorFactory, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.containerFactory = containerFactory;
        this.containerManager = containerManager;
        this.interceptorFactory = interceptorFactory;
        this.monitor = monitor;
        this.handlerRegistry = handlerRegistry;
    }

    public void attach(JmsWireSource source, PhysicalWireTarget target, Wire wire) throws Fabric3Exception {
        URI serviceUri = target.getUri();
        ClassLoader loader = source.getClassLoader();
        SessionType trxType = source.getSessionType();
        WireHolder wireHolder = this.createWireHolder(wire, source, target);
        ResolvedObjects objects = this.resolveAdministeredObjects(source);
        ContainerConfiguration configuration = new ContainerConfiguration();
        ConnectionFactory requestFactory = objects.getRequestFactory();
        javax.jms.Destination requestDestination = objects.getRequestDestination();
        ConnectionFactory responseFactory = objects.getResponseFactory();
        javax.jms.Destination responseDestination = objects.getResponseDestination();
        List<BindingHandler<Message>> handlers = this.createHandlers(source);
        ServiceListener listener = new ServiceListener(wireHolder, responseDestination, responseFactory, trxType, loader, handlers, this.monitor);
        configuration.setDestination(requestDestination);
        configuration.setFactory(requestFactory);
        configuration.setMessageListener(listener);
        configuration.setUri(serviceUri);
        configuration.setSessionType(trxType);
        this.populateConfiguration(configuration, source.getMetadata());
        if (this.containerManager.isRegistered(serviceUri)) {
            this.containerManager.unregister(serviceUri);
        }
        AdaptiveMessageContainer container = this.containerFactory.create(configuration);
        this.containerManager.register(container);
    }

    public void detach(JmsWireSource source, PhysicalWireTarget target) throws Fabric3Exception {
        this.containerManager.unregister(target.getUri());
        this.resolver.release(source.getMetadata().getConnectionFactory());
    }

    private void populateConfiguration(ContainerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.ADMINISTERED_OBJECTS == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        if (metadata.getUriMessageSelection() != null) {
            configuration.setMessageSelector(metadata.getUriMessageSelection().getSelector());
        } else if (metadata.getMessageSelection() != null) {
            configuration.setMessageSelector(metadata.getMessageSelection().getSelector());
        }
    }

    private ResolvedObjects resolveAdministeredObjects(JmsWireSource source) throws Fabric3Exception {
        JmsBindingMetadata metadata = source.getMetadata();
        ConnectionFactoryDefinition requestDefinition = metadata.getConnectionFactory();
        ConnectionFactory requestConnectionFactory = this.resolver.resolve(requestDefinition);
        Destination destination = metadata.getDestination();
        javax.jms.Destination requestDestination = this.resolver.resolve(destination, requestConnectionFactory);
        this.validateDestination(requestDestination, destination);
        ConnectionFactory responseConnectionFactory = null;
        javax.jms.Destination responseDestination = null;
        if (metadata.isResponse()) {
            ConnectionFactoryDefinition responseDefinition = metadata.getResponseConnectionFactory();
            responseConnectionFactory = this.resolver.resolve(responseDefinition);
            Destination responseDestinationDefinition = metadata.getResponseDestination();
            if (responseDestinationDefinition != null) {
                responseDestination = this.resolver.resolve(responseDestinationDefinition, responseConnectionFactory);
                this.validateDestination(responseDestination, responseDestinationDefinition);
            }
        }
        return new ResolvedObjects(requestConnectionFactory, requestDestination, responseConnectionFactory, responseDestination);
    }

    private void validateDestination(javax.jms.Destination requestDestination, Destination requestDestinationDefinition) throws Fabric3Exception {
        DestinationType requestDestinationType = requestDestinationDefinition.geType();
        if (DestinationType.QUEUE == requestDestinationType && !(requestDestination instanceof Queue)) {
            throw new Fabric3Exception("Destination is not a queue: " + requestDestinationDefinition.getName());
        }
        if (DestinationType.TOPIC == requestDestinationType && !(requestDestination instanceof Topic)) {
            throw new Fabric3Exception("Destination is not a topic: " + requestDestinationDefinition.getName());
        }
    }

    private WireHolder createWireHolder(Wire wire, JmsWireSource source, PhysicalWireTarget target) throws Fabric3Exception {
        JmsBindingMetadata metadata = source.getMetadata();
        List<OperationPayloadTypes> types = source.getPayloadTypes();
        CorrelationScheme correlationScheme = metadata.getCorrelationScheme();
        ArrayList<InvocationChainHolder> chainHolders = new ArrayList<InvocationChainHolder>();
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperation physicalOperation = chain.getPhysicalOperation();
            OperationPayloadTypes payloadType = this.resolveOperation(physicalOperation.getName(), types);
            if (payloadType == null) {
                throw new Fabric3Exception("Payload type not found for operation: " + physicalOperation.getName());
            }
            if (source.getDataTypes().contains(PhysicalDataTypes.JAXB)) {
                this.addJAXBInterceptor(source, target, physicalOperation, chain);
            }
            chainHolders.add(new InvocationChainHolder(chain, payloadType));
        }
        return new WireHolder(chainHolders, correlationScheme);
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private List<BindingHandler<Message>> createHandlers(JmsWireSource source) {
        if (source.getHandlers().isEmpty()) {
            return null;
        }
        ArrayList<BindingHandler<Message>> handlers = new ArrayList<BindingHandler<Message>>();
        for (PhysicalBindingHandler physicalHandler : source.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(Message.class, physicalHandler);
            handlers.add((BindingHandler<Message>)handler);
        }
        return handlers;
    }

    private void addJAXBInterceptor(JmsWireSource source, PhysicalWireTarget target, PhysicalOperation op, InvocationChain chain) {
        ClassLoader sourceClassLoader = source.getClassLoader();
        ClassLoader targetClassLoader = target.getClassLoader();
        List<DataType> jaxTypes = DataTypeHelper.createTypes(op);
        Interceptor jaxbInterceptor = this.interceptorFactory.createInterceptor(op, DataTypeHelper.JAXB_TYPES, jaxTypes, targetClassLoader, sourceClassLoader);
        chain.addInterceptor(jaxbInterceptor);
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private ConnectionFactory responseFactory;
        private javax.jms.Destination requestDestination;
        private javax.jms.Destination responseDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, javax.jms.Destination requestDestination, ConnectionFactory responseFactory, javax.jms.Destination responseDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
            this.responseFactory = responseFactory;
            this.responseDestination = responseDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public ConnectionFactory getResponseFactory() {
            return this.responseFactory;
        }

        public javax.jms.Destination getRequestDestination() {
            return this.requestDestination;
        }

        public javax.jms.Destination getResponseDestination() {
            return this.responseDestination;
        }
    }
}

