/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import javax.jms.ConnectionFactory;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.HeadersDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.binding.jms.runtime.channel.JmsEventStreamHandler;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTarget;
import org.fabric3.spi.container.builder.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.oasisopen.sca.annotation.Reference;

@Key(value="org.fabric3.binding.jms.spi.provision.JmsConnectionTarget")
public class JmsConnectionTargetAttacher
implements TargetConnectionAttacher<JmsConnectionTarget> {
    private AdministeredObjectResolver resolver;

    public JmsConnectionTargetAttacher(@Reference AdministeredObjectResolver resolver) {
        this.resolver = resolver;
    }

    public void attach(PhysicalConnectionSource source, JmsConnectionTarget target, ChannelConnection connection) {
        JmsBindingMetadata metadata = target.getMetadata();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        HeadersDefinition headers = metadata.getHeaders();
        boolean persistent = DeliveryMode.PERSISTENT == headers.getDeliveryMode() || headers.getDeliveryMode() == null;
        ConnectionFactory connectionFactory = this.resolver.resolve(connectionFactoryDefinition);
        Destination destinationDefinition = metadata.getDestination();
        javax.jms.Destination destination = this.resolver.resolve(destinationDefinition, connectionFactory);
        EventStream stream = connection.getEventStream();
        JmsEventStreamHandler handler = new JmsEventStreamHandler(destination, connectionFactory, persistent);
        stream.addHandler((EventStreamHandler)handler);
    }

    public void detach(PhysicalConnectionSource source, JmsConnectionTarget target) {
        this.resolver.release(target.getMetadata().getConnectionFactory());
    }
}

