/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.introspection;

import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryConfiguration;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryResource;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.binding.jms.spi.introspection.ConnectionFactoryConfigurationParser;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="{urn:fabric3.org}connection.factory")
public class ConnectionFactoryResourceLoader
implements TypeLoader<ConnectionFactoryResource> {
    @Reference(required=false)
    protected Map<String, ConnectionFactoryConfigurationParser> parsers = Collections.emptyMap();

    public ConnectionFactoryResource load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ConnectionFactoryConfigurationParser parser;
        if (this.parsers.isEmpty()) {
            return null;
        }
        String provider = reader.getAttributeValue(null, "provider");
        if (provider == null) {
            parser = this.parsers.values().iterator().next();
        } else {
            parser = this.parsers.get(provider);
            if (parser == null) {
                UnrecognizedAttribute error = new UnrecognizedAttribute("JMS provider not installed: " + provider, reader.getLocation(), new ModelObject[0]);
                context.addError((ValidationFailure)error);
                return null;
            }
        }
        ConnectionFactoryConfiguration configuration = parser.parse(reader, context);
        return new ConnectionFactoryResource(configuration);
    }
}

