/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.io.InputStream;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;

public class PayloadTypeIntrospectorImpl
implements PayloadTypeIntrospector {
    private static final String JAXB = "JAXB";

    @Override
    public OperationPayloadTypes introspect(Operation operation) throws Fabric3Exception {
        PayloadType inputType = this.getInputPayloadType(operation);
        PayloadType outputType = this.introspectType(operation.getOutputType());
        PayloadType faultType = this.getFaultPayloadType(operation);
        return new OperationPayloadTypes(operation.getName(), inputType, outputType, faultType);
    }

    private PayloadType getInputPayloadType(Operation operation) throws Fabric3Exception {
        List inputTypes = operation.getInputTypes();
        if (inputTypes.size() == 1) {
            DataType param = (DataType)inputTypes.get(0);
            return this.introspectType(param);
        }
        return PayloadType.OBJECT;
    }

    private PayloadType getFaultPayloadType(Operation operation) throws Fabric3Exception {
        for (DataType dataType : operation.getFaultTypes()) {
            if (!JAXB.equals(dataType.getDatabinding())) continue;
            return PayloadType.TEXT;
        }
        return PayloadType.OBJECT;
    }

    private PayloadType introspectType(DataType param) throws Fabric3Exception {
        Class type = param.getType();
        if (type.isPrimitive() && !Void.TYPE.equals(type)) {
            return this.calculatePrimitivePayloadType(type);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return PayloadType.STREAM;
        }
        if (String.class.isAssignableFrom(type) || JAXB.equals(param.getDatabinding())) {
            return PayloadType.TEXT;
        }
        return PayloadType.OBJECT;
    }

    private PayloadType calculatePrimitivePayloadType(Class<?> clazz) throws Fabric3Exception {
        if (Short.TYPE.equals(clazz)) {
            return PayloadType.SHORT;
        }
        if (Integer.TYPE.equals(clazz)) {
            return PayloadType.INTEGER;
        }
        if (Double.TYPE.equals(clazz)) {
            return PayloadType.DOUBLE;
        }
        if (Float.TYPE.equals(clazz)) {
            return PayloadType.FLOAT;
        }
        if (Long.TYPE.equals(clazz)) {
            return PayloadType.LONG;
        }
        if (Character.TYPE.equals(clazz)) {
            return PayloadType.CHARACTER;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return PayloadType.BOOLEAN;
        }
        if (Byte.TYPE.equals(clazz)) {
            return PayloadType.BYTE;
        }
        throw new Fabric3Exception("Parameter type not supported: " + clazz);
    }
}

