/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.ActivationSpec;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.JmsBinding;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsWireSource;
import org.fabric3.binding.jms.spi.provision.JmsWireTarget;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.domain.generator.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.api.binding.jms.model.JmsBinding")
public class JmsWireBindingGenerator
implements WireBindingGenerator<JmsBinding> {
    private static final String JAXB = "JAXB";
    private static final String MANAGED_TRANSACTION = "managedTransaction";
    private static final String MANAGED_TRANSACTION_GLOBAL = "managedTransaction.global";
    private static final String MANAGED_TRANSACTION_LOCAL = "managedTransaction.local";
    private PayloadTypeIntrospector introspector;
    private HostInfo info;
    private JmsResourceProvisioner provisioner;

    public JmsWireBindingGenerator(@Reference PayloadTypeIntrospector introspector, @Reference HostInfo info) {
        this.introspector = introspector;
        this.info = info;
    }

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public JmsWireSource generateSource(LogicalBinding<JmsBinding> binding, ServiceContract contract, List<LogicalOperation> operations) throws Fabric3Exception {
        SessionType sessionType = this.getSessionType((LogicalComponent)((LogicalBindable)binding.getParent()).getParent());
        JmsBindingMetadata metadata = ((JmsBinding)binding.getDefinition()).getJmsMetadata().snapshot();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        if (metadata.getResponseConnectionFactory() != null) {
            JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getResponseConnectionFactory(), sessionType);
        }
        this.processServiceResponse(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        URI uri = ((JmsBinding)binding.getDefinition()).getTargetUri();
        List<PhysicalBindingHandler> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBinding)binding.getDefinition());
        JmsWireSource source = this.isJAXB(contract) ? new JmsWireSource(uri, metadata, payloadTypes, sessionType, handlers, PhysicalDataTypes.JAXB) : new JmsWireSource(uri, metadata, payloadTypes, sessionType, handlers);
        if (this.provisioner != null) {
            this.provisioner.generateSource(source);
        }
        this.processDestinationDefinitions(metadata, false);
        return source;
    }

    public JmsWireTarget generateTarget(LogicalBinding<JmsBinding> binding, ServiceContract contract, List<LogicalOperation> operations) throws Fabric3Exception {
        SessionType sessionType = this.getSessionType((LogicalComponent)((LogicalBindable)binding.getParent()).getParent());
        URI uri = ((JmsBinding)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBinding)binding.getDefinition()).getJmsMetadata().snapshot();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        if (metadata.getResponseConnectionFactory() != null) {
            JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getResponseConnectionFactory(), sessionType);
        }
        this.processReferenceResponse(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        List<PhysicalBindingHandler> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBinding)binding.getDefinition());
        JmsWireTarget definition = this.isJAXB(contract) ? new JmsWireTarget(uri, metadata, payloadTypes, sessionType, handlers, PhysicalDataTypes.JAXB) : new JmsWireTarget(uri, metadata, payloadTypes, sessionType, handlers);
        if (this.provisioner != null) {
            this.provisioner.generateTarget(definition);
        }
        this.processDestinationDefinitions(metadata, true);
        if (contract.getCallbackContract() != null) {
            for (LogicalBinding callbackBinding : ((LogicalBindable)binding.getParent()).getCallbackBindings()) {
                if (!(callbackBinding.getDefinition() instanceof JmsBinding)) continue;
                JmsBinding callbackDefinition = (JmsBinding)callbackBinding.getDefinition();
                Destination callbackDestination = callbackDefinition.getJmsMetadata().getDestination();
                definition.setCallbackDestination(callbackDestination);
            }
        }
        return definition;
    }

    private boolean isJAXB(ServiceContract contract) {
        for (Operation operation : contract.getOperations()) {
            if (operation.getInputTypes().isEmpty() || !JAXB.equals(((DataType)operation.getInputTypes().get(0)).getDatabinding())) continue;
            return true;
        }
        return false;
    }

    private void processReferenceResponse(JmsBindingMetadata metadata, ServiceContract contract) {
        if (metadata.isResponse()) {
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.isOneWay()) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            Destination destination = new Destination();
            destination.setCreate(CreateOption.IF_NOT_EXIST);
            destination.setName(metadata.getDestination().getName() + "Response");
            responseDefinition.setDestination(destination);
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private void processServiceResponse(JmsBindingMetadata metadata, ServiceContract contract) throws Fabric3Exception {
        if (metadata.isResponse()) {
            if (metadata.getResponse().getActivationSpec() != null) {
                throw new Fabric3Exception("Activation spec not allowed on a service binding response");
            }
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.isOneWay()) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private SessionType getSessionType(LogicalComponent<?> component) {
        List policies = component.getDefinition().getComponentType().getPolicies();
        if (policies.contains(MANAGED_TRANSACTION) || policies.contains(MANAGED_TRANSACTION_GLOBAL) || policies.contains(MANAGED_TRANSACTION_LOCAL)) {
            return SessionType.GLOBAL_TRANSACTED;
        }
        return SessionType.AUTO_ACKNOWLEDGE;
    }

    private List<OperationPayloadTypes> processPayloadTypes(ServiceContract serviceContract) throws Fabric3Exception {
        ArrayList<OperationPayloadTypes> types = new ArrayList<OperationPayloadTypes>();
        for (Operation operation : serviceContract.getOperations()) {
            OperationPayloadTypes payloadType = this.introspector.introspect(operation);
            types.add(payloadType);
        }
        return types;
    }

    private void processDestinationDefinitions(JmsBindingMetadata metadata, boolean reference) throws Fabric3Exception {
        ActivationSpec spec;
        Destination destination = metadata.getDestination();
        if (destination == null && (spec = metadata.getActivationSpec()) != null) {
            if (reference) {
                throw new Fabric3Exception("Activation specification not allowed on a reference");
            }
            destination = this.populateActivationInformation(spec);
            metadata.setDestination(destination);
        }
        Destination responseDestination = metadata.getResponseDestination();
        ResponseDefinition responseDefinition = metadata.getResponse();
        if (responseDestination == null && responseDefinition != null && responseDefinition.getActivationSpec() != null) {
            ActivationSpec spec2 = responseDefinition.getActivationSpec();
            responseDestination = this.populateActivationInformation(spec2);
            responseDefinition.setDestination(responseDestination);
        }
    }

    private Destination populateActivationInformation(ActivationSpec spec) {
        Destination destination = new Destination();
        destination.setCreate(spec.getCreate());
        destination.setName(spec.getName());
        destination.addProperties(spec.getProperties());
        return destination;
    }
}

