/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.JmsBinding;
import org.fabric3.api.model.type.component.BindingHandler;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.model.physical.PhysicalBindingHandler;

public class JmsGeneratorHelper {
    public static String getSubscriptionId(URI uri) {
        String id = uri.getPath().substring(1).replace("/", ".");
        String fragment = uri.getFragment();
        if (fragment != null) {
            id = id + "." + fragment;
        }
        return id;
    }

    public static void generateDefaultFactoryConfiguration(ConnectionFactoryDefinition factory, SessionType sessionType) {
        if (factory.getName() == null && !factory.getProperties().containsKey("class")) {
            if (SessionType.GLOBAL_TRANSACTED == sessionType) {
                factory.setName("xaDefault");
            } else {
                factory.setName("default");
            }
        }
    }

    public static List<PhysicalBindingHandler> generateBindingHandlers(URI domainUri, JmsBinding definition) {
        ArrayList<PhysicalBindingHandler> handlers = new ArrayList<PhysicalBindingHandler>();
        for (BindingHandler handlerDefinition : definition.getHandlers()) {
            URI resolvedUri = URI.create(domainUri.toString() + "/" + handlerDefinition.getTarget());
            handlers.add(new PhysicalBindingHandler(resolvedUri));
        }
        return handlers;
    }

    private JmsGeneratorHelper() {
    }
}

