/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBinding;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSource;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTarget;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.domain.generator.ConnectionBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.DeliveryType;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.api.binding.jms.model.JmsBinding")
public class JmsConnectionBindingGenerator
implements ConnectionBindingGenerator<JmsBinding> {
    private static final String JAXB = "JAXB";
    private JmsResourceProvisioner provisioner;

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public PhysicalConnectionSource generateConnectionSource(LogicalConsumer consumer, LogicalBinding<JmsBinding> binding, DeliveryType deliveryType) {
        JmsBindingMetadata metadata = ((JmsBinding)binding.getDefinition()).getJmsMetadata().snapshot();
        SessionType sessionType = this.getSessionType(binding);
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        URI uri = consumer.getUri();
        if (metadata.getSubscriptionId() == null && metadata.isDurable()) {
            String prefix = metadata.getSubscriptionIdPrefix() != null ? metadata.getSubscriptionIdPrefix() + "-" : "";
            metadata.setSubscriptionId(prefix + JmsGeneratorHelper.getSubscriptionId(uri));
        }
        String specifier = metadata.getSubscriptionId();
        metadata.setSubscriptionId(specifier);
        metadata.getDestination().setType(DestinationType.TOPIC);
        Consumer consumerDefinition = consumer.getDefinition();
        DataType dataType = this.isJAXB(consumerDefinition.getType()) ? PhysicalDataTypes.JAXB : PhysicalDataTypes.JAVA_TYPE;
        JmsConnectionSource source = new JmsConnectionSource(uri, metadata, dataType, sessionType);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionSource(source);
        }
        return source;
    }

    private SessionType getSessionType(LogicalBinding<JmsBinding> binding) {
        return ((JmsBinding)binding.getDefinition()).getJmsMetadata().isClientAcknowledge() ? SessionType.CLIENT_ACKNOWLEDGE : SessionType.AUTO_ACKNOWLEDGE;
    }

    public PhysicalConnectionTarget generateConnectionTarget(LogicalProducer producer, LogicalBinding<JmsBinding> binding, DeliveryType deliveryType) {
        URI uri = ((JmsBinding)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBinding)binding.getDefinition()).getJmsMetadata().snapshot();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), SessionType.AUTO_ACKNOWLEDGE);
        DataType type = this.isJAXB((DataType)producer.getStreamOperation().getDefinition().getInputTypes().get(0)) ? PhysicalDataTypes.JAXB : PhysicalDataTypes.JAVA_TYPE;
        JmsConnectionTarget target = new JmsConnectionTarget(uri, metadata, type);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionTarget(target);
        }
        return target;
    }

    private boolean isJAXB(DataType eventType) {
        return JAXB.equals(eventType.getDatabinding());
    }
}

