/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryConfiguration;
import org.fabric3.binding.jms.spi.provision.PhysicalConnectionFactory;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreatorRegistry;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.spi.container.builder.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.binding.jms.spi.provision.PhysicalConnectionFactory")
public class ConnectionFactoryBuilder
implements ResourceBuilder<PhysicalConnectionFactory> {
    private ConnectionFactoryCreatorRegistry registry;
    private ConnectionFactoryManager manager;

    public ConnectionFactoryBuilder(@Reference ConnectionFactoryCreatorRegistry registry, @Reference ConnectionFactoryManager manager) {
        this.registry = registry;
        this.manager = manager;
    }

    public void build(PhysicalConnectionFactory physicalFactory) {
        ConnectionFactoryConfiguration configuration = physicalFactory.getConfiguration();
        ConnectionFactory factory = this.registry.create(configuration);
        String name = configuration.getName();
        Map<String, String> factoryProperties = this.getProperties(configuration);
        this.manager.register(name, factory, factoryProperties);
    }

    public void remove(PhysicalConnectionFactory definition) {
        ConnectionFactory factory = this.manager.unregister(definition.getConfiguration().getName());
        this.registry.release(factory);
    }

    private Map<String, String> getProperties(ConnectionFactoryConfiguration configuration) {
        Properties properties = configuration.getFactoryProperties();
        HashMap<String, String> factoryProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            factoryProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return factoryProperties;
    }
}

