/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jmx.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.security.auth.Subject;
import org.fabric3.api.Role;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.jmx.management.AbstractMBean;
import org.fabric3.jmx.management.MethodHolder;
import org.fabric3.jmx.management.OperationKey;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;

public class OptimizedMBean<T>
extends AbstractMBean {
    private final Supplier<T> supplier;
    private final Map<String, MethodHolder> getters;
    private final Map<String, MethodHolder> setters;
    private final Map<OperationKey, MethodHolder> operations;
    private boolean authorization;

    public OptimizedMBean(Supplier<T> supplier, MBeanInfo mbeanInfo, Map<String, MethodHolder> getters, Map<String, MethodHolder> setters, Map<OperationKey, MethodHolder> operations, boolean authorization) {
        super(mbeanInfo);
        this.supplier = supplier;
        this.getters = getters;
        this.setters = setters;
        this.operations = operations;
        this.authorization = authorization;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MethodHolder holder = this.getters.get(attribute);
        if (holder == null) {
            throw new AttributeNotFoundException(attribute);
        }
        if (this.authorization) {
            this.authorize(holder.getRoles());
        }
        Method method = holder.getMethod();
        return this.invoke(method, null);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MethodHolder holder = this.setters.get(attribute.getName());
        if (holder == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        if (this.authorization) {
            this.authorize(holder.getRoles());
        }
        Method method = holder.getMethod();
        this.invoke(method, new Object[]{attribute.getValue()});
    }

    @Override
    public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        OperationKey operation = new OperationKey(s, strings);
        MethodHolder holder = this.operations.get(operation);
        if (holder == null) {
            throw new ReflectionException(new NoSuchMethodException(operation.toString()));
        }
        if (this.authorization) {
            this.authorize(holder.getRoles());
        }
        Method method = holder.getMethod();
        return this.invoke(method, objects);
    }

    private void authorize(Set<Role> roles) throws MBeanException {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        for (Role role : roles) {
            if (!subject.getPrincipals().contains(role)) continue;
            return;
        }
        throw new MBeanException(new Exception("Not authorized"));
    }

    Object invoke(Method method, Object[] args) throws MBeanException, ReflectionException {
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        try {
            T instance = this.supplier.get();
            Object object = method.invoke(instance, args);
            return object;
        }
        catch (Fabric3Exception e) {
            throw new ReflectionException((Exception)((Object)e));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof Exception) {
                throw new MBeanException((Exception)e.getCause());
            }
            throw new ReflectionException(e);
        }
        finally {
            workContext.reset();
        }
    }
}

