/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jmx.management;

import java.lang.reflect.Method;
import java.util.Arrays;

public class OperationKey {
    private String name;
    private String description;
    private String[] params;
    private int hashCode;

    public OperationKey(String name, String[] params) {
        this.name = name;
        this.params = params;
        this.hashCode = 31 * this.name.hashCode() + Arrays.hashCode(this.params);
    }

    public OperationKey(Method method, String description) {
        this.description = description;
        this.name = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        this.params = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            this.params[i] = paramTypes[i].getName();
        }
        this.hashCode = 31 * this.name.hashCode() + Arrays.hashCode(this.params);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sig = new StringBuilder();
        sig.append(this.name).append('(');
        if (this.params != null && this.params.length > 0) {
            sig.append(this.params[0]);
            for (int i = 1; i < this.params.length; ++i) {
                sig.append(',').append(this.params[i]);
            }
        }
        sig.append(')');
        return sig.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationKey that = (OperationKey)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.params == null && that.params == null) {
            return true;
        }
        return Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

