/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jmx.management;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.api.model.type.java.ManagementOperationInfo;
import org.fabric3.api.model.type.java.OperationType;
import org.fabric3.jmx.management.MethodHolder;
import org.fabric3.jmx.management.OperationKey;
import org.fabric3.jmx.management.OptimizedMBean;
import org.fabric3.spi.management.ManagementExtension;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JMXManagementExtension
implements ManagementExtension {
    private static final String DOMAIN = "fabric3";
    boolean authorization;
    private MBeanServer mBeanServer;
    private URI applicationDomain;

    @Property(required=false)
    public void setSecurity(String security) {
        this.authorization = "AUTHORIZATION".equals(security.toUpperCase());
    }

    public JMXManagementExtension(@Reference MBeanServer mBeanServer, @Reference HostInfo info) {
        this.mBeanServer = mBeanServer;
        this.applicationDomain = info.getDomain();
    }

    public String getType() {
        return "fabric3.jmx";
    }

    public void export(URI componentUri, ManagementInfo info, Supplier<?> supplier) {
        if (this.mBeanServer == null) {
            return;
        }
        try {
            ObjectName name = this.getObjectName(componentUri, info);
            OptimizedMBean<?> mBean = this.createOptimizedMBean(info, supplier);
            if (!this.mBeanServer.isRegistered(name)) {
                this.mBeanServer.registerMBean(mBean, name);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | JMException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    public void export(String name, String group, String description, Object instance) {
        try {
            OptimizedMBean<Object> managementBean;
            group = this.parseGroup(group);
            ObjectName objectName = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=" + group + ", name=" + name);
            boolean isStandardMBean = this.isStandardMBean(instance);
            String path = "";
            if (isStandardMBean) {
                managementBean = instance;
            } else {
                Class<?> clazz = instance.getClass();
                ClassLoader loader = clazz.getClassLoader();
                HashSet<Role> readRoles = new HashSet<Role>();
                HashSet<Role> writeRoles = new HashSet<Role>();
                Management annotation = clazz.getAnnotation(Management.class);
                if (annotation != null) {
                    String[] writeRoleNames;
                    String[] readRoleNames;
                    for (String roleName : readRoleNames = annotation.readRoles()) {
                        readRoles.add(new Role(roleName));
                    }
                    for (String roleName : writeRoleNames = annotation.writeRoles()) {
                        writeRoles.add(new Role(roleName));
                    }
                    path = annotation.path();
                }
                if (readRoles.isEmpty()) {
                    readRoles.add(new Role("ROLE_FABRIC3_ADMIN"));
                    readRoles.add(new Role("ROLE_FABRIC3_OBSERVER"));
                }
                if (writeRoles.isEmpty()) {
                    writeRoles.add(new Role("ROLE_FABRIC3_ADMIN"));
                }
                ManagementInfo info = new ManagementInfo(name, group, path, description, clazz.getName(), readRoles, writeRoles);
                this.introspect(instance, info);
                managementBean = this.createOptimizedMBean(info, () -> instance);
            }
            if (!this.mBeanServer.isRegistered(objectName)) {
                this.mBeanServer.registerMBean(managementBean, objectName);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | JMException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    public void remove(URI componentUri, ManagementInfo info) {
        try {
            ObjectName name = this.getObjectName(componentUri, info);
            this.mBeanServer.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    public void remove(String name, String group) {
        try {
            group = this.parseGroup(group);
            ObjectName objectName = new ObjectName("fabric3:SubDomain=runtime, type=resource, group=" + group + ", name=" + name);
            this.mBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private String parseGroup(String group) {
        String[] path = group.split("/");
        if (path.length > 1) {
            StringBuilder builder = new StringBuilder(path[0]);
            for (int i = 1; i < path.length; ++i) {
                String token = path[i];
                builder.append(", group").append(i).append("=").append(token);
            }
            group = builder.toString();
        }
        return group;
    }

    private boolean isStandardMBean(Object instance) {
        boolean isStandardMBean = false;
        for (Class<?> interfaze : instance.getClass().getInterfaces()) {
            if (!interfaze.getSimpleName().endsWith("MBean")) continue;
            isStandardMBean = true;
            break;
        }
        return isStandardMBean;
    }

    private void introspect(Object instance, ManagementInfo info) {
        for (Method method : instance.getClass().getMethods()) {
            ManagementOperation annotation = method.getAnnotation(ManagementOperation.class);
            if (annotation == null) continue;
            String description = annotation.description();
            if (description.trim().length() == 0) {
                description = null;
            }
            String[] roleNames = annotation.rolesAllowed();
            HashSet<Role> roles = new HashSet<Role>();
            for (String name : roleNames) {
                roles.add(new Role(name));
            }
            String path = annotation.path();
            ManagementOperationInfo operationInfo = new ManagementOperationInfo(method, path, OperationType.UNDEFINED, description, roles);
            info.addOperation(operationInfo);
        }
    }

    private ObjectName getObjectName(URI uri, ManagementInfo info) throws MalformedObjectNameException {
        String component;
        String subDomain;
        if (uri.toString().startsWith("fabric3://runtime")) {
            subDomain = "runtime";
            component = info.getName() == null ? UriHelper.getDefragmentedNameAsString((URI)uri).substring("fabric3://runtime".length() + 1) : info.getName();
        } else {
            subDomain = this.applicationDomain.getAuthority();
            component = info.getName() == null ? UriHelper.getDefragmentedNameAsString((URI)uri).substring(this.applicationDomain.toString().length() + 1) : info.getName();
        }
        String group = info.getGroup();
        if (group != null) {
            return new ObjectName("fabric3:SubDomain=" + subDomain + ", type=component, group=" + group + ", name=" + component);
        }
        return new ObjectName("fabric3:SubDomain=" + subDomain + ", type=component, name=" + component);
    }

    private <T> OptimizedMBean<T> createOptimizedMBean(ManagementInfo info, Supplier<T> supplier) throws IntrospectionException, ClassNotFoundException, NoSuchMethodException {
        String className = info.getManagementClass();
        HashSet<AttributeDescription> attributes = new HashSet<AttributeDescription>();
        HashMap<String, MethodHolder> getters = new HashMap<String, MethodHolder>();
        HashMap<String, MethodHolder> setters = new HashMap<String, MethodHolder>();
        HashMap<OperationKey, MethodHolder> operations = new HashMap<OperationKey, MethodHolder>();
        for (ManagementOperationInfo operationInfo : info.getOperations()) {
            Method method = operationInfo.getMethod();
            String description = operationInfo.getDescription();
            Set roles = operationInfo.getRoles();
            switch (this.getType(method)) {
                case GETTER: {
                    String getterName = this.getAttributeName(method);
                    AttributeDescription attribute = new AttributeDescription(getterName, description);
                    attributes.add(attribute);
                    if (roles.isEmpty()) {
                        roles = info.getReadRoles();
                    }
                    MethodHolder holder = new MethodHolder(method, roles);
                    getters.put(getterName, holder);
                    break;
                }
                case SETTER: {
                    String setterName = this.getAttributeName(method);
                    AttributeDescription attribute = new AttributeDescription(setterName, description);
                    attributes.add(attribute);
                    if (roles.isEmpty()) {
                        roles = info.getWriteRoles();
                    }
                    MethodHolder holder = new MethodHolder(method, roles);
                    setters.put(setterName, holder);
                    break;
                }
                case OPERATION: {
                    OperationKey key = new OperationKey(method, description);
                    if (roles.isEmpty()) {
                        roles = info.getWriteRoles();
                    }
                    MethodHolder holder = new MethodHolder(method, roles);
                    operations.put(key, holder);
                }
            }
        }
        MBeanAttributeInfo[] mBeanAttributes = this.createAttributeInfo(attributes, getters, setters);
        MBeanOperationInfo[] mBeanOperations = this.createOperationInfo(operations);
        String description = info.getDescription();
        MBeanInfo mbeanInfo = new MBeanInfo(className, description, mBeanAttributes, null, mBeanOperations, null);
        return new OptimizedMBean<T>(supplier, mbeanInfo, getters, setters, operations, this.authorization);
    }

    private MBeanOperationInfo[] createOperationInfo(Map<OperationKey, MethodHolder> operations) {
        MBeanOperationInfo[] mBeanOperations = new MBeanOperationInfo[operations.size()];
        int i = 0;
        for (Map.Entry<OperationKey, MethodHolder> entry : operations.entrySet()) {
            String description = entry.getKey().getDescription();
            Method value = entry.getValue().getMethod();
            mBeanOperations[i++] = new MBeanOperationInfo(description, value);
        }
        return mBeanOperations;
    }

    private MBeanAttributeInfo[] createAttributeInfo(Set<AttributeDescription> descriptions, Map<String, MethodHolder> getters, Map<String, MethodHolder> setters) throws IntrospectionException {
        MBeanAttributeInfo[] mBeanAttributes = new MBeanAttributeInfo[descriptions.size()];
        int i = 0;
        for (AttributeDescription description : descriptions) {
            String name = description.getName();
            MethodHolder getterHolder = getters.get(name);
            Method getter = null;
            if (getterHolder != null) {
                getter = getterHolder.getMethod();
            }
            MethodHolder setterHolder = setters.get(name);
            Method setter = null;
            if (setterHolder != null) {
                setter = setterHolder.getMethod();
            }
            mBeanAttributes[i++] = new MBeanAttributeInfo(name, description.getDescription(), getter, setter);
        }
        return mBeanAttributes;
    }

    private MethodType getType(Method method) {
        String name = method.getName();
        Class<?> returnType = method.getReturnType();
        int paramCount = method.getParameterTypes().length;
        if (Void.TYPE.equals(returnType) && name.length() > 3 && name.startsWith("set") && paramCount == 1) {
            return MethodType.SETTER;
        }
        if (Boolean.TYPE.equals(returnType) && name.length() > 2 && name.startsWith("is") && paramCount == 0) {
            return MethodType.GETTER;
        }
        if (name.length() > 3 && name.startsWith("get") && paramCount == 0) {
            return MethodType.GETTER;
        }
        return MethodType.OPERATION;
    }

    private String getAttributeName(Method method) {
        String name = method.getName();
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name.substring(3);
    }

    private class AttributeDescription {
        private String name;
        private String description;

        private AttributeDescription(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeDescription that = (AttributeDescription)o;
            return !(this.description == null ? that.description != null : !this.description.equals(that.description)) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }

    private static enum MethodType {
        GETTER,
        SETTER,
        OPERATION;

    }
}

