/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.tx.AbstractTxSupport;
import org.fabric3.tx.TxAction;
import org.fabric3.tx.TxMonitor;

public class TxEventStreamHandler
extends AbstractTxSupport
implements EventStreamHandler {
    private EventStreamHandler next;

    public TxEventStreamHandler(TransactionManager tm, TxAction action, TxMonitor monitor) {
        super(tm, action, monitor);
    }

    public void handle(Object event, boolean endOfBatch) {
        Transaction transaction = this.getTransaction();
        if (this.txAction == TxAction.BEGIN) {
            if (transaction == null) {
                this.begin();
            }
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.suspend();
        }
        try {
            this.next.handle(event, endOfBatch);
        }
        catch (RuntimeException e) {
            if (this.txAction == TxAction.BEGIN && transaction == null) {
                this.rollback();
            } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
                this.resume(transaction);
            }
            throw e;
        }
        if (this.txAction == TxAction.BEGIN && transaction == null) {
            this.commit();
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.resume(transaction);
        }
    }

    public EventStreamHandler getNext() {
        return this.next;
    }

    public void setNext(EventStreamHandler next) {
        this.next = next;
    }
}

