/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.zone;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.framework.zone.ZoneResourceMonitor;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.management.rest.spi.DuplicateResourceNameException;
import org.fabric3.management.rest.spi.ResourceHost;
import org.fabric3.management.rest.spi.ResourceListener;
import org.fabric3.management.rest.spi.ResourceMapping;
import org.fabric3.management.rest.spi.Verb;
import org.fabric3.management.rest.transformer.TransformerPair;
import org.fabric3.spi.federation.topology.ParticipantTopologyService;
import org.fabric3.spi.federation.topology.ZoneChannelException;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/zone")
public class ZoneResourceService
implements ResourceListener {
    private static final String RUNTIME_PATH = "/runtime/";
    private ResourceHost resourceHost;
    private ZoneResourceMonitor monitor;
    private HostInfo info;
    private ParticipantTopologyService topologyService;
    private List<ResourceMapping> subresources = new ArrayList<ResourceMapping>();
    private List<ResourceMapping> registered = new ArrayList<ResourceMapping>();

    public ZoneResourceService(@Reference ResourceHost resourceHost, @Reference HostInfo info, @Monitor ZoneResourceMonitor monitor) {
        this.resourceHost = resourceHost;
        this.info = info;
        this.monitor = monitor;
    }

    @Reference(required=false)
    public void setTopologyService(ParticipantTopologyService topologyService) {
        this.topologyService = topologyService;
    }

    @Destroy
    public void destroy() throws ZoneChannelException {
        for (ResourceMapping mapping : this.registered) {
            this.resourceHost.unregister(mapping.getPath());
        }
    }

    @ManagementOperation(path="/")
    public Resource getZoneResource(HttpServletRequest request) throws ResourceException {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        String leaderName = this.getLeader();
        resource.setProperty("name", this.info.getRuntimeName());
        resource.setProperty("leader", leaderName);
        this.createRuntimeLink(request, resource);
        return resource;
    }

    @ManagementOperation(path="runtime")
    public Resource getZoneRuntimeResource(HttpServletRequest request) throws ResourceException {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        String requestUrl = ResourceHelper.getRequestUrl(request);
        for (ResourceMapping mapping : this.subresources) {
            String path = mapping.getRelativePath();
            URL url = ResourceHelper.createUrl(requestUrl + '/' + path);
            Link link = new Link(path, "edit", url);
            resource.setProperty(link.getName(), link);
        }
        return resource;
    }

    @Override
    public void onRootResourceExport(ResourceMapping mapping) {
        if (!mapping.getPath().startsWith(RUNTIME_PATH)) {
            return;
        }
        String identifier = "zone" + mapping.getPath();
        String path = "/zone" + mapping.getPath();
        String relativePath = "/".equals(mapping.getRelativePath()) ? mapping.getPath().substring(RUNTIME_PATH.length()) : mapping.getRelativePath().substring(RUNTIME_PATH.length());
        Verb verb = mapping.getVerb();
        Object instance = mapping.getInstance();
        Method method = mapping.getMethod();
        TransformerPair pair = mapping.getPair();
        Set<Role> roles = mapping.getRoles();
        ResourceMapping newMapping = new ResourceMapping(identifier, path, relativePath, verb, method, instance, true, pair, roles);
        this.subresources.add(newMapping);
        try {
            if (this.resourceHost.isPathRegistered(path, verb)) {
                this.resourceHost.unregisterPath(path, verb);
            }
            this.resourceHost.register(newMapping);
            this.registered.add(newMapping);
        }
        catch (DuplicateResourceNameException e) {
            this.monitor.error("Duplicate mapping: " + path, (Throwable)((Object)e));
        }
    }

    @Override
    public void onSubResourceExport(ResourceMapping mapping) {
        if (!mapping.getPath().startsWith(RUNTIME_PATH)) {
            return;
        }
        String identifier = "zone" + mapping.getIdentifier();
        String path = "/zone" + mapping.getPath();
        String relativePath = "/zone" + mapping.getRelativePath();
        Verb verb = mapping.getVerb();
        Object instance = mapping.getInstance();
        Method method = mapping.getMethod();
        TransformerPair pair = mapping.getPair();
        Set<Role> roles = mapping.getRoles();
        ResourceMapping newMapping = new ResourceMapping(identifier, path, relativePath, verb, method, instance, true, pair, roles);
        try {
            this.resourceHost.register(newMapping);
            this.registered.add(newMapping);
        }
        catch (DuplicateResourceNameException e) {
            this.monitor.error("Duplicate mapping: " + path, (Throwable)((Object)e));
        }
    }

    @Override
    public void onRootResourceRemove(String identifier) {
        this.resourceHost.unregister("zone" + identifier);
    }

    @Override
    public void onSubResourceRemove(String identifier) {
        this.resourceHost.unregister("zone" + identifier);
    }

    private String getLeader() {
        if (this.topologyService == null) {
            return this.info.getRuntimeName();
        }
        return this.topologyService.getZoneLeaderName();
    }

    private void createRuntimeLink(HttpServletRequest request, Resource resource) {
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request) + "/runtime");
        Link link = new Link("runtime", "edit", url);
        resource.setProperty("runtime", link);
    }
}

