/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.zone;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.spi.federation.addressing.AddressCache;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/zones")
public class ZonesResourceService {
    private AddressCache addressCache;
    private HostInfo hostInfo;

    public ZonesResourceService(@Reference AddressCache addressCache, @Reference HostInfo hostInfo) {
        this.addressCache = addressCache;
        this.hostInfo = hostInfo;
    }

    @ManagementOperation(path="/")
    public Set<Link> getZones(HttpServletRequest request) {
        if (RuntimeMode.VM == this.hostInfo.getRuntimeMode()) {
            return this.createLocalZoneLink(request);
        }
        return this.createDistributedZonesLink();
    }

    private Set<Link> createLocalZoneLink(HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        URL zoneUrl = ResourceHelper.createUrl(requestUrl.substring(0, requestUrl.toString().indexOf("/management/") + 12) + "zone");
        Link link = new Link("LocalZone", "edit", zoneUrl);
        return Collections.singleton(link);
    }

    private Set<Link> createDistributedZonesLink() {
        HashSet<Link> list = new HashSet<Link>();
        HashSet<String> zones = new HashSet<String>();
        for (SocketAddress address : this.addressCache.getActiveAddresses("f3.http.server")) {
            String zone = address.getZone();
            if (zones.contains(zone)) continue;
            int httpPort = address.getPort().getNumber();
            String host = address.getAddress();
            URL zoneUrl = ResourceHelper.createUrl("http://" + host + ":" + httpPort + "/management/zone");
            Link link = new Link(zone, "edit", zoneUrl);
            list.add(link);
            zones.add(zone);
        }
        return list;
    }
}

