/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.runtime;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Link;
import org.fabric3.spi.federation.addressing.AddressCache;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/runtimes")
public class RuntimesResourceService {
    private HostInfo info;
    private AddressCache addressCache;

    public RuntimesResourceService(@Reference HostInfo info, @Reference AddressCache addressCache) {
        this.info = info;
        this.addressCache = addressCache;
    }

    @ManagementOperation(path="/")
    public Set<Link> getRuntimes(HttpServletRequest request) {
        if (this.info.getRuntimeMode() == RuntimeMode.VM) {
            return this.createLocalRuntimeLink(request);
        }
        return this.createDistributedRuntimesLink();
    }

    private Set<Link> createLocalRuntimeLink(HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        URL runtimeUrl = ResourceHelper.createUrl(requestUrl.substring(0, requestUrl.toString().indexOf("/management/") + 12) + "runtime");
        Link link = new Link(this.info.getRuntimeName(), "edit", runtimeUrl);
        return Collections.singleton(link);
    }

    private Set<Link> createDistributedRuntimesLink() {
        HashSet<Link> list = new HashSet<Link>();
        List addresses = this.addressCache.getActiveAddresses("f3.http.server");
        for (SocketAddress address : addresses) {
            int httpPort = address.getPort().getNumber();
            String host = address.getAddress();
            URL runtimeUrl = ResourceHelper.createUrl("http://" + host + ":" + httpPort + "/management/runtime");
            String runtimeName = address.getRuntimeName();
            Link link = new Link(runtimeName, "edit", runtimeUrl);
            list.add(link);
        }
        return list;
    }
}

