/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.contribution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.contribution.ContributionException;
import org.fabric3.api.host.contribution.ContributionNotFoundException;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.DuplicateContributionException;
import org.fabric3.api.host.contribution.RemoveException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.contribution.UninstallException;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.framework.domain.contribution.ContributionsResourceMonitor;
import org.fabric3.management.rest.framework.domain.contribution.WrappedStreamContributionSource;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.Response;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/contributions/profiles")
public class ProfilesResourceService {
    private static final String EXTENSIONS = "extensions";
    private ContributionService contributionService;
    private MetaDataStore store;
    private ContributionsResourceMonitor monitor;

    public ProfilesResourceService(@Reference ContributionService contributionService, @Reference MetaDataStore store, @Monitor ContributionsResourceMonitor monitor) {
        this.contributionService = contributionService;
        this.store = store;
        this.monitor = monitor;
    }

    @ManagementOperation(path="/")
    public Resource getProfiles(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        Set contributions = this.store.getContributions();
        HashSet profiles = new HashSet();
        for (Contribution contribution : contributions) {
            profiles.addAll(contribution.getProfiles());
        }
        resource.setProperty("profiles", profiles);
        return resource;
    }

    @ManagementOperation(path="profile")
    public Response createProfile(HttpServletRequest request) throws ResourceException {
        String path = request.getPathInfo();
        int pos = path.lastIndexOf("/");
        String name = path.substring(pos + 1);
        try {
            URI uri = new URI(name);
            ServletInputStream stream = request.getInputStream();
            this.store(uri, (InputStream)stream);
            this.contributionService.installProfile(uri);
            Response response = new Response(HttpStatus.CREATED);
            response.addHeader("Location", path);
            return response;
        }
        catch (URISyntaxException e) {
            this.monitor.error("Invalid contribution URI:", e);
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Invalid profile URI: " + name);
        }
        catch (DuplicateContributionException e) {
            this.monitor.error("Duplicate profile:" + name, e);
            throw new ResourceException(HttpStatus.CONFLICT, "Profile already exists: " + name);
        }
        catch (IOException | ContributionException e) {
            this.monitor.error("Error creating contribution: " + name, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error creating profile: " + name);
        }
    }

    @ManagementOperation(path="profile")
    public void deleteProfile(String uri) throws ResourceException {
        URI profileUri = URI.create(uri);
        try {
            this.contributionService.uninstallProfile(profileUri);
            this.contributionService.removeProfile(profileUri);
        }
        catch (UninstallException e) {
            this.monitor.error("Error removing profile: " + uri, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error removing profile: " + uri);
        }
        catch (RemoveException e) {
            this.monitor.error("Error removing contribution: " + uri, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error removing profile: " + uri);
        }
        catch (ContributionNotFoundException e) {
            throw new ResourceException(HttpStatus.NOT_FOUND, "Profile not found: " + uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<URI> store(URI profileUri, InputStream stream) throws IOException, URISyntaxException, StoreException {
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            ArrayList<URI> contributionUris = new ArrayList<URI>();
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String[] tokens;
                if (entry.isDirectory() || (tokens = entry.getName().split("/")).length != 2 || !EXTENSIONS.equals(tokens[0])) continue;
                URI contributionUri = new URI(tokens[1]);
                if (!this.contributionService.exists(contributionUri)) {
                    WrappedStreamContributionSource contributionSource = new WrappedStreamContributionSource(contributionUri, jarStream, true);
                    this.contributionService.store((ContributionSource)contributionSource);
                }
                contributionUris.add(contributionUri);
            }
            this.contributionService.registerProfile(profileUri, contributionUris);
            ArrayList<URI> arrayList = contributionUris;
            return arrayList;
        }
        finally {
            try {
                if (jarStream != null) {
                    jarStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

