/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.contribution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.contribution.ArtifactValidationFailure;
import org.fabric3.api.host.contribution.ContributionAlreadyInstalledException;
import org.fabric3.api.host.contribution.ContributionInUseException;
import org.fabric3.api.host.contribution.ContributionLockedException;
import org.fabric3.api.host.contribution.ContributionNotFoundException;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.contribution.DuplicateContributionException;
import org.fabric3.api.host.contribution.InputStreamContributionSource;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.RemoveException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.contribution.UninstallException;
import org.fabric3.api.host.contribution.UnresolvedImportException;
import org.fabric3.api.host.contribution.UnsupportedContentTypeException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.framework.domain.contribution.ContributionResource;
import org.fabric3.management.rest.framework.domain.contribution.ContributionStatus;
import org.fabric3.management.rest.framework.domain.contribution.ContributionsResourceMonitor;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.Response;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.introspection.validation.InvalidContributionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/contributions")
public class ContributionsResourceService {
    private ContributionService contributionService;
    private MetaDataStore store;
    private ContributionsResourceMonitor monitor;

    public ContributionsResourceService(@Reference ContributionService contributionService, @Reference MetaDataStore store, @Monitor ContributionsResourceMonitor monitor) {
        this.contributionService = contributionService;
        this.store = store;
        this.monitor = monitor;
    }

    @ManagementOperation(path="/")
    public Resource getContributions(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        Set contributions = this.store.getContributions();
        ArrayList<ContributionStatus> list = new ArrayList<ContributionStatus>();
        for (Contribution contribution : contributions) {
            URI uri = contribution.getUri();
            Link link = this.createContributionLink(uri, request);
            String state = contribution.getState().toString();
            ContributionStatus status = new ContributionStatus(uri, state, link);
            list.add(status);
        }
        resource.setProperty("contributions", list);
        return resource;
    }

    @ManagementOperation(path="contribution")
    public Response createContribution(HttpServletRequest request) throws ResourceException {
        URI uri;
        String path = request.getPathInfo();
        int pos = path.lastIndexOf("/");
        String name = path.substring(pos + 1);
        try {
            uri = new URI(name);
            InputStreamContributionSource source = new InputStreamContributionSource(uri, (InputStream)request.getInputStream());
            this.contributionService.store((ContributionSource)source);
        }
        catch (URISyntaxException e) {
            this.monitor.error("Invalid contribution URI: " + e.getReason());
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Invalid contribution URI: " + name);
        }
        catch (IOException e) {
            this.monitor.error("Error creating contribution: " + name, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error creating contribution: " + name);
        }
        catch (DuplicateContributionException e) {
            this.monitor.error("Duplicate contribution:" + name);
            throw new ResourceException(HttpStatus.CONFLICT, "Contribution already exists: " + name);
        }
        catch (StoreException e) {
            this.monitor.error("Error creating contribution: " + name, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error creating contribution: " + name);
        }
        try {
            this.contributionService.install(uri);
            Response response = new Response(HttpStatus.CREATED);
            response.addHeader("Location", path);
            return response;
        }
        catch (ContributionNotFoundException e) {
            String message = "Contribution not found: " + name;
            this.monitor.error(message);
            throw new ResourceException(HttpStatus.BAD_REQUEST, message);
        }
        catch (ContributionAlreadyInstalledException e) {
            String message = "Contribution already installed: " + name;
            this.monitor.error(message);
            throw new ResourceException(HttpStatus.BAD_REQUEST, message);
        }
        catch (UnresolvedImportException e) {
            String message = "The import " + e.getImport() + " could not be resolved: " + name;
            this.monitor.error(message);
            throw new ResourceException(HttpStatus.BAD_REQUEST, message);
        }
        catch (UnsupportedContentTypeException e) {
            String message = "Unknown contribution type: " + name;
            this.monitor.error(message);
            throw new ResourceException(HttpStatus.BAD_REQUEST, message);
        }
        catch (InvalidContributionException e) {
            ResourceException resourceException = new ResourceException(HttpStatus.VALIDATION_ERROR, "Invalid contribution: " + name);
            this.propagate(e, resourceException);
            throw resourceException;
        }
        catch (InstallException e) {
            String message = "Error creating contribution: " + name;
            this.monitor.error(message, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, message);
        }
    }

    @ManagementOperation(path="contribution")
    public ContributionResource getContribution(String uri) throws ResourceException {
        URI contributionUri = URI.create(uri);
        Contribution contribution = this.store.find(contributionUri);
        if (contribution == null) {
            throw new ResourceException(HttpStatus.NOT_FOUND, "Contribution not found: " + uri);
        }
        String state = contribution.getState().toString();
        List deployables = contribution.getManifest().getDeployables();
        ArrayList<QName> names = new ArrayList<QName>();
        for (Deployable deployable : deployables) {
            QName name = deployable.getName();
            names.add(name);
        }
        return new ContributionResource(contributionUri, state, names);
    }

    @ManagementOperation(path="contribution")
    public void deleteContribution(String uri) throws ResourceException {
        URI contributionUri = URI.create(uri);
        try {
            this.contributionService.uninstall(contributionUri);
            this.contributionService.remove(contributionUri);
        }
        catch (ContributionInUseException e) {
            this.monitor.error("Contribution must be undeployed before it is uninstalled: " + uri);
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Contribution must be undeployed before it is uninstalled: " + uri);
        }
        catch (ContributionLockedException e) {
            this.monitor.error("Unable to uninstall contribution in use: " + uri);
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Unable to uninstall contribution in use: " + uri);
        }
        catch (RemoveException | UninstallException e) {
            this.monitor.error("Error removing contribution: " + uri, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error removing contribution: " + uri);
        }
        catch (ContributionNotFoundException e) {
            throw new ResourceException(HttpStatus.NOT_FOUND, "Contribution not found: " + uri);
        }
    }

    private Link createContributionLink(URI contributionUri, HttpServletRequest request) {
        String uri = contributionUri.toString();
        String requestUrl = ResourceHelper.getRequestUrl(request);
        URL url = ResourceHelper.createUrl(requestUrl + "/contribution/" + uri);
        return new Link(uri, "edit", url);
    }

    private void propagate(InvalidContributionException e, ResourceException resourceException) {
        HashMap errors = new HashMap();
        for (ValidationFailure failure : e.getErrors()) {
            if (failure instanceof ArtifactValidationFailure) {
                ArtifactValidationFailure avf = (ArtifactValidationFailure)failure;
                ArrayList<String> artifactErrors = new ArrayList<String>();
                errors.put(avf.getArtifactName(), artifactErrors);
                for (ValidationFailure entry : avf.getFailures()) {
                    artifactErrors.add(entry.getMessage());
                }
                continue;
            }
            ArrayList<String> generalErrors = (ArrayList<String>)errors.get("General");
            if (generalErrors == null) {
                generalErrors = new ArrayList<String>();
                errors.put("General", generalErrors);
            }
            generalErrors.add(failure.getMessage());
        }
        resourceException.setEntity(errors);
    }
}

