/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.component;

import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.framework.domain.component.ComponentResource;
import org.fabric3.management.rest.framework.domain.component.CompositeResource;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Response;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/components")
public class ComponentsResourceService {
    private static final String COMPONENT_BASE_PATH = "/domain/components/";
    private LogicalComponentManager lcm;

    public ComponentsResourceService(@Reference(name="lcm") LogicalComponentManager lcm) {
        this.lcm = lcm;
    }

    @ManagementOperation(path="/")
    public Response getComponents(HttpServletRequest request) {
        LogicalComponent root = this.findComponent(request);
        if (root == null) {
            return new Response(HttpStatus.NOT_FOUND);
        }
        if (root instanceof LogicalCompositeComponent) {
            CompositeResource domainResource = this.createCompositeResource(root, request);
            return new Response(HttpStatus.OK, domainResource);
        }
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request));
        ComponentResource resource = this.createComponentResource(root, url);
        return new Response(HttpStatus.OK, resource);
    }

    private LogicalComponent findComponent(HttpServletRequest request) {
        LogicalCompositeComponent component;
        String pathInfo = request.getPathInfo();
        if (pathInfo.startsWith(COMPONENT_BASE_PATH)) {
            String name = pathInfo.substring(COMPONENT_BASE_PATH.length());
            String base = this.lcm.getRootComponent().getUri().toString() + "/";
            URI uri = URI.create(base + name);
            component = this.lcm.getComponent(uri);
        } else {
            component = this.lcm.getRootComponent();
        }
        return component;
    }

    private CompositeResource createCompositeResource(LogicalComponent composite, HttpServletRequest request) {
        CompositeResource compositeResource = new CompositeResource(composite.getUri(), composite.getZone());
        URL url = ResourceHelper.createUrl(ResourceHelper.getRequestUrl(request));
        SelfLink selfLink = new SelfLink(url);
        compositeResource.setSelfLink(selfLink);
        String baseUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/management" + COMPONENT_BASE_PATH;
        this.copy((LogicalCompositeComponent)composite, compositeResource, baseUrl);
        return compositeResource;
    }

    private ComponentResource createComponentResource(LogicalComponent component, URL url) {
        ComponentResource resource = new ComponentResource(component.getUri(), component.getZone());
        SelfLink selfLink = new SelfLink(url);
        resource.setSelfLink(selfLink);
        return resource;
    }

    private void copy(LogicalCompositeComponent composite, CompositeResource resource, String baseUrl) {
        for (LogicalComponent component : composite.getComponents()) {
            ComponentResource childResource;
            URL url = ResourceHelper.createUrl(baseUrl + component.getUri().getPath().substring(1));
            if (component instanceof LogicalCompositeComponent) {
                childResource = new CompositeResource(component.getUri(), component.getZone());
                SelfLink selfLink = new SelfLink(url);
                childResource.setSelfLink(selfLink);
                this.copy((LogicalCompositeComponent)component, (CompositeResource)childResource, baseUrl);
                resource.addComponent(childResource);
                continue;
            }
            childResource = this.createComponentResource(component, url);
            resource.addComponent(childResource);
        }
    }
}

