/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.xpath;

import java.util.Collections;
import java.util.List;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class UriRefFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() != 1) {
            throw new FunctionCallException("Invalid number of arguments for URIRef(): " + args.size());
        }
        String uri = args.get(0).toString();
        List nodeSet = context.getNodeSet();
        for (LogicalComponent component : nodeSet) {
            LogicalComponent ret;
            if (component.getUri().getSchemeSpecificPart().equals(uri)) {
                return component;
            }
            if (!(component instanceof LogicalCompositeComponent) || (ret = this.find(uri, (LogicalCompositeComponent)component)) == null) continue;
            return ret;
        }
        return Collections.emptyList();
    }

    private LogicalComponent find(String uri, LogicalCompositeComponent composite) {
        for (LogicalComponent child : composite.getComponents()) {
            LogicalComponent component;
            if (child.getUri().getSchemeSpecificPart().equals(uri)) {
                return child;
            }
            if (!(child instanceof LogicalCompositeComponent) || (component = this.find(uri, (LogicalCompositeComponent)child)) == null) continue;
            return component;
        }
        return null;
    }
}

