/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fabric3.policy.xpath.IntentRefsFunction;
import org.fabric3.policy.xpath.LogicalModelNavigator;
import org.fabric3.policy.xpath.OperationRefFunction;
import org.fabric3.policy.xpath.UriRefFunction;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.SimpleNamespaceContext;

public class LogicalModelXPath
extends BaseXPath {
    private static final long serialVersionUID = 7175741342820843731L;
    private static final Function INTENT_REFS = new IntentRefsFunction();
    private static final Function URI_REF = new UriRefFunction();
    private static final Function OPERATION_REF = new OperationRefFunction();

    public LogicalModelXPath(String xpathExpr) throws JaxenException {
        super(xpathExpr, LogicalModelNavigator.getInstance());
        this.validateInfoset(xpathExpr);
        SimpleNamespaceContext nc = new SimpleNamespaceContext();
        nc.addNamespace("sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
        nc.addNamespace("f3", "urn:fabric3.org");
        this.setNamespaceContext((NamespaceContext)nc);
        SimpleFunctionContext fc = this.initFunctionContext();
        this.setFunctionContext((FunctionContext)fc);
    }

    private void validateInfoset(String xpathExpr) throws JaxenException {
        if (xpathExpr.contains(":property[")) {
            throw new JaxenException("Properties are not valid attach to targets: " + xpathExpr);
        }
    }

    public Object evaluate(Object node) throws JaxenException {
        Object result = super.evaluate(node);
        if (result instanceof LogicalComponent) {
            return result;
        }
        if (result instanceof Collection) {
            ArrayList newList = new ArrayList();
            for (Object member : (Collection)result) {
                newList.add(member);
            }
            return newList;
        }
        return result;
    }

    protected Context getContext(Object node) {
        if (node instanceof Context) {
            return (Context)node;
        }
        if (node instanceof LogicalComponent) {
            return super.getContext(node);
        }
        if (node instanceof List) {
            ArrayList newList = new ArrayList();
            for (Object o : (List)node) {
                newList.add(o);
            }
            return super.getContext(newList);
        }
        return super.getContext(node);
    }

    private SimpleFunctionContext initFunctionContext() {
        SimpleFunctionContext fc = new SimpleFunctionContext();
        fc.registerFunction("http://docs.oasis-open.org/ns/opencsa/sca/200912", "URIRef", URI_REF);
        fc.registerFunction(null, "URIRef", URI_REF);
        fc.registerFunction("http://docs.oasis-open.org/ns/opencsa/sca/200912", "IntentRefs", INTENT_REFS);
        fc.registerFunction(null, "IntentRefs", INTENT_REFS);
        fc.registerFunction("http://docs.oasis-open.org/ns/opencsa/sca/200912", "OperationRef", OPERATION_REF);
        fc.registerFunction(null, "OperationRef", OPERATION_REF);
        return fc;
    }
}

