/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class IntentRefsFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.isEmpty()) {
            throw new FunctionCallException("Invalid number of arguments specified in IntentRefs(): " + args.size());
        }
        List<String> intentArgs = this.normalizeIntents(args);
        HashSet<LogicalScaArtifact> artifacts = new HashSet<LogicalScaArtifact>();
        List nodeSet = context.getNodeSet();
        for (LogicalComponent component : nodeSet) {
            this.containsIntents(intentArgs, component, artifacts);
        }
        return new ArrayList(artifacts);
    }

    private void containsIntents(List<String> intentArgs, LogicalComponent<?> component, Set<LogicalScaArtifact> artifacts) {
        if (this.containsIntents(intentArgs, component.getDefinition().getImplementation().getIntents())) {
            artifacts.add((LogicalScaArtifact)component);
        }
        if (this.containsIntents(intentArgs, component.getDefinition().getIntents())) {
            artifacts.add((LogicalScaArtifact)component);
        }
        if (this.containsIntents(intentArgs, component.getIntents())) {
            artifacts.add((LogicalScaArtifact)component);
        }
        for (LogicalService service : component.getServices()) {
            if (!this.containsIntents(intentArgs, service.getIntents())) continue;
            artifacts.add((LogicalScaArtifact)service);
        }
        for (LogicalReference reference : component.getReferences()) {
            if (!this.containsIntents(intentArgs, reference.getIntents())) continue;
            artifacts.add((LogicalScaArtifact)reference);
        }
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
            for (LogicalComponent childComponent : composite.getComponents()) {
                this.containsIntents(intentArgs, childComponent, artifacts);
            }
        }
    }

    private boolean containsIntents(Collection<String> intentArgs, Set<QName> intents) {
        boolean contains = true;
        for (String intentArg : intentArgs) {
            if (this.containsIntent(intentArg, intents)) continue;
            contains = false;
            break;
        }
        return contains;
    }

    private boolean containsIntent(String intentArg, Set<QName> intents) {
        boolean found = false;
        for (QName intent : intents) {
            if (!intent.getLocalPart().equals(intentArg)) continue;
            found = true;
            break;
        }
        return found;
    }

    private List<String> normalizeIntents(List args) throws FunctionCallException {
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Invalid argument type specified in IntentRefs(): " + args.get(0).getClass());
        }
        ArrayList<String> intentArgs = new ArrayList<String>();
        for (Object arg : args) {
            String stringArg = (String)arg;
            int pos = stringArg.indexOf(":");
            if (pos < 0) continue;
            intentArgs.add(stringArg.substring(pos + 1));
        }
        return intentArgs;
    }
}

