/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.definitions.BindingType;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.policy.resolver.AbstractPolicyResolver;
import org.fabric3.policy.resolver.IntentPair;
import org.fabric3.policy.resolver.IntentResolutionException;
import org.fabric3.policy.resolver.InteractionPolicyResolver;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.generator.policy.PolicyRegistry;
import org.fabric3.spi.domain.generator.policy.PolicyResolutionException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.oasisopen.sca.annotation.Reference;

public class InteractionPolicyResolverImpl
extends AbstractPolicyResolver
implements InteractionPolicyResolver {
    private static final QName TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName IMMEDIATE_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "immediateOneWay");
    private static final QName LOCAL_MANAGED_TRANSACTION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "managedTransaction.local");
    private static final QName NO_MANAGED_TRANSACTION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "noManagedTransaction");
    private static final QName PROPAGATES_TRANSACTION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "propagatesTransaction");
    private static final QName ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final QName ASYNC_INVOCATION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "asyncInvocation");
    private static final QName NO_LISTENER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "noListener");

    public InteractionPolicyResolverImpl(@Reference PolicyRegistry policyRegistry, @Reference LogicalComponentManager lcm, @Reference PolicyEvaluator policyEvaluator) {
        super(policyRegistry, lcm, policyEvaluator);
    }

    @Override
    public IntentPair resolveIntents(LogicalOperation operation, QName bindingType) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.aggregateOperationIntents(operation);
        Set<Intent> providedIntents = this.filterProvidedIntents(bindingType, requiredIntents);
        return new IntentPair(requiredIntents, providedIntents);
    }

    @Override
    public IntentPair resolveIntents(LogicalBinding binding) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.aggregateBindingIntents(binding);
        QName type = binding.getDefinition().getType();
        Set<Intent> providedIntents = this.filterProvidedIntents(type, requiredIntents);
        return new IntentPair(requiredIntents, providedIntents);
    }

    @Override
    public Set<PolicySet> resolvePolicySets(LogicalBinding binding) throws PolicyResolutionException {
        QName type = binding.getDefinition().getType();
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        Set alwaysProvidedIntents = new LinkedHashSet();
        Set mayProvidedIntents = new LinkedHashSet();
        if (bindingType != null) {
            alwaysProvidedIntents = bindingType.getAlwaysProvide();
            mayProvidedIntents = bindingType.getMayProvide();
        }
        Set<Intent> requiredIntents = this.aggregateBindingIntents(binding);
        HashSet<Intent> requiredIntentsCopy = new HashSet<Intent>(requiredIntents);
        for (Intent intent : requiredIntentsCopy) {
            QName intentName = intent.getName();
            if (!alwaysProvidedIntents.contains(intentName) && !mayProvidedIntents.contains(intentName)) continue;
            requiredIntents.remove(intent);
        }
        Set<PolicySet> policies = this.resolvePolicies(requiredIntents, (LogicalScaArtifact<?>)binding);
        if (!requiredIntents.isEmpty()) {
            throw new IntentResolutionException("Unable to resolve all intents", requiredIntents);
        }
        Set<QName> policySets = this.aggregateBindingPolicySets(binding);
        for (QName name : policySets) {
            PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
            policies.add(policySet);
        }
        return policies;
    }

    @Override
    public Set<PolicySet> resolvePolicySets(LogicalOperation operation, LogicalScaArtifact<?> artifact, QName type) throws PolicyResolutionException {
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        Set alwaysProvidedIntents = new LinkedHashSet();
        Set mayProvidedIntents = new LinkedHashSet();
        if (bindingType != null) {
            alwaysProvidedIntents = bindingType.getAlwaysProvide();
            mayProvidedIntents = bindingType.getMayProvide();
        }
        Set<Intent> requiredIntents = this.aggregateOperationIntents(operation);
        HashSet<Intent> requiredIntentsCopy = new HashSet<Intent>(requiredIntents);
        for (Intent intent : requiredIntentsCopy) {
            QName intentName = intent.getName();
            if (!alwaysProvidedIntents.contains(intentName) && !mayProvidedIntents.contains(intentName)) continue;
            requiredIntents.remove(intent);
        }
        Set<QName> policySets = this.getOperationPolicySets(operation);
        if (requiredIntents.isEmpty() && policySets.isEmpty()) {
            return Collections.emptySet();
        }
        Set<PolicySet> policies = this.resolvePolicies(requiredIntents, artifact);
        if (!requiredIntents.isEmpty()) {
            throw new IntentResolutionException("Unable to resolve all intents", requiredIntents);
        }
        for (QName name : policySets) {
            PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
            policies.add(policySet);
        }
        return policies;
    }

    private Set<Intent> aggregateOperationIntents(LogicalOperation operation) throws PolicyResolutionException {
        LinkedHashSet<QName> intentNames = new LinkedHashSet<QName>();
        intentNames.addAll(operation.getIntents());
        return this.expandAndFilterIntents(intentNames, (LogicalScaArtifact)operation);
    }

    private Set<Intent> aggregateBindingIntents(LogicalBinding<?> binding) throws PolicyResolutionException {
        Set<QName> intentNames = this.aggregateIntents(binding);
        return this.expandAndFilterIntents(intentNames, (LogicalScaArtifact)binding);
    }

    private Set<Intent> expandAndFilterIntents(Set<QName> intentNames, LogicalScaArtifact artifact) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.resolveIntents(intentNames);
        this.validateIntents(requiredIntents, artifact);
        this.filterInvalidIntents(Intent.BINDING, requiredIntents);
        this.filterMutuallyExclusiveIntents(requiredIntents);
        return requiredIntents;
    }

    private void validateIntents(Set<Intent> intents, LogicalScaArtifact artifact) throws PolicyResolutionException {
        LogicalOperation operation;
        List operations;
        Bindable parent;
        LogicalBinding binding;
        if (intents.isEmpty()) {
            return;
        }
        boolean isTransactedOneWay = false;
        boolean isImmediateOneWay = false;
        boolean isNoManagedTransaction = false;
        boolean isLocalTransaction = false;
        boolean propagatesTransaction = false;
        boolean asyncInvocation = false;
        for (Intent intent : intents) {
            if (!isTransactedOneWay && (isTransactedOneWay = TRANSACTED_ONEWAY.equals(intent.getName())) || !isImmediateOneWay && (isImmediateOneWay = IMMEDIATE_ONEWAY.equals(intent.getName())) || !isNoManagedTransaction && (isNoManagedTransaction = NO_MANAGED_TRANSACTION.equals(intent.getName())) || !isLocalTransaction && (isLocalTransaction = LOCAL_MANAGED_TRANSACTION.equals(intent.getName())) || !asyncInvocation && (asyncInvocation = ASYNC_INVOCATION.equals(intent.getName())) || !propagatesTransaction && (propagatesTransaction = PROPAGATES_TRANSACTION.equals(intent.getName())) || !NO_LISTENER.equals(intent.getName()) || artifact.getParent() instanceof LogicalReference) continue;
            throw new PolicyResolutionException("The noListener intent can only be specified on a reference");
        }
        if (isNoManagedTransaction && isTransactedOneWay) {
            throw new PolicyResolutionException("Cannot specify a one-way interaction on a component that is configured for no transaction context");
        }
        if (isNoManagedTransaction && propagatesTransaction) {
            throw new PolicyResolutionException("Cannot specify propagates transaction on a component that is configured for no transaction context");
        }
        if (isLocalTransaction && isTransactedOneWay) {
            throw new PolicyResolutionException("Cannot specify a transacted one-way interaction on a component that is configured for a local transaction");
        }
        if (isLocalTransaction && propagatesTransaction) {
            throw new PolicyResolutionException("Cannot specify propagates transaction on a component that is configured for a local transaction context");
        }
        if (asyncInvocation && propagatesTransaction) {
            throw new PolicyResolutionException("Cannot specify propagates transaction on an async invocation");
        }
        if (isTransactedOneWay) {
            if (artifact instanceof LogicalBinding) {
                binding = (LogicalBinding)artifact;
                parent = (Bindable)binding.getParent();
                operations = parent.getOperations();
                for (LogicalOperation operation2 : operations) {
                    if (operation2.getIntents().contains(ONEWAY)) continue;
                    throw new PolicyResolutionException("Cannot specify transacted one-way for a request-response operation: " + parent.getUri());
                }
            } else if (artifact instanceof LogicalOperation && !(operation = (LogicalOperation)artifact).getIntents().contains(ONEWAY)) {
                throw new PolicyResolutionException("Cannot specify transacted one-way for a request-response operation: " + ((LogicalAttachPoint)operation.getParent()).getUri());
            }
        }
        if (isImmediateOneWay) {
            if (artifact instanceof LogicalBinding) {
                binding = (LogicalBinding)artifact;
                parent = (Bindable)binding.getParent();
                operations = parent.getOperations();
                for (LogicalOperation operation2 : operations) {
                    if (operation2.getIntents().contains(ONEWAY)) continue;
                    throw new PolicyResolutionException("Cannot specify immediate one-way for a request-response operation: " + parent.getUri());
                }
            } else if (artifact instanceof LogicalOperation && !(operation = (LogicalOperation)artifact).getIntents().contains(ONEWAY)) {
                throw new PolicyResolutionException("Cannot specify immediate one-way for a request-response operation: " + ((LogicalAttachPoint)operation.getParent()).getUri());
            }
        }
    }

    private Set<QName> getOperationPolicySets(LogicalOperation operation) {
        LinkedHashSet<QName> policySetNames = new LinkedHashSet<QName>();
        for (LogicalOperation temp = operation; temp != null; temp = temp.getParent()) {
            policySetNames.addAll(temp.getPolicySets());
        }
        return policySetNames;
    }

    private Set<QName> aggregateBindingPolicySets(LogicalBinding<?> binding) {
        LinkedHashSet<QName> policySetNames = new LinkedHashSet<QName>();
        for (LogicalScaArtifact temp = binding; temp != null; temp = temp.getParent()) {
            policySetNames.addAll(temp.getPolicySets());
        }
        return policySetNames;
    }

    private Set<Intent> filterProvidedIntents(QName type, Set<Intent> requiredIntents) {
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        if (bindingType == null) {
            return Collections.emptySet();
        }
        Set mayProvidedIntents = bindingType.getMayProvide();
        LinkedHashSet<Intent> intentsToBeProvided = new LinkedHashSet<Intent>();
        for (Intent intent : requiredIntents) {
            if (!mayProvidedIntents.contains(intent.getName())) continue;
            intentsToBeProvided.add(intent);
        }
        return intentsToBeProvided;
    }
}

